package com.qiankun.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.qiankun.entity.Certificate;
import com.qiankun.entity.Contacts;
import com.qiankun.entity.User;
import com.qiankun.vo.CertificateVo;
import com.qiankun.vo.UserVo;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URL;
import java.util.*;
import java.util.List;

public class UserUtils {

    public static UserVo converToVo(User user){
        UserVo vo = null;
        if (user != null){
            vo = new UserVo();
            BeanUtils.copyProperties(user,vo);
            Set<Contacts> contacts = user.getContacts();
            if (contacts != null){
                Iterator<Contacts> its = contacts.iterator();
                Integer count = 0;
                while (its.hasNext()) {
                    Contacts c = its.next();
                    if (count == 0) {
                        vo.setContactsAddr1(c.getAddr());
                        vo.setContactsName1(c.getName());
                        vo.setContactsMobile1(c.getMobile());
                        vo.setContactsRelation1(c.getRelation());
                        vo.setContactsWeixin1(c.getWeixin());
                        vo.setContactsQQ1(c.getQq());
                        count ++;
                    } else {
                        vo.setContactsAddr2(c.getAddr());
                        vo.setContactsName2(c.getName());
                        vo.setContactsMobile2(c.getMobile());
                        vo.setContactsRelation2(c.getRelation());
                        vo.setContactsWeixin2(c.getWeixin());
                        vo.setContactsQQ2(c.getQq());
                    }


                }
            }

        }
        return vo;
    }
    public static void generateCertificate(String imageTemplatePath, String outputImagePath, List<CertificateVo> addTexts) throws IOException {
        InputStream templateInput = null;
        FileOutputStream fileOutput = null;
        try {
            templateInput = loadTemplateImage(imageTemplatePath);
            Image image = ImageIO.read(templateInput);
            int imageWidth = image.getWidth(null);
            int imageHeight = image.getHeight(null);

            BufferedImage bufferedImage = new BufferedImage(imageWidth,imageHeight,BufferedImage.TYPE_INT_RGB);
            Graphics2D graphics = bufferedImage.createGraphics();
            graphics.drawImage(image,0,0,imageWidth,imageHeight,null);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL,RenderingHints.VALUE_STROKE_NORMALIZE);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING,RenderingHints.VALUE_RENDER_QUALITY);

            //draw text
            for (CertificateVo txtVo : addTexts){
                graphics.setFont(txtVo.getFont());
                graphics.setColor(txtVo.getColor());
                graphics.drawString(txtVo.getText(),txtVo.getX(),txtVo.getY());
            }
            File file = new File(outputImagePath);
            if (!file.getParentFile().exists()){
                FileUtils.forceMkdir(file.getParentFile());
            }
            fileOutput = new FileOutputStream(outputImagePath);
            ImageIO.write(bufferedImage,"jpeg",fileOutput);
            fileOutput.flush();
        }finally {
            if (templateInput != null){
                IOUtils.closeQuietly(templateInput);
            }
            if (fileOutput != null){
                IOUtils.closeQuietly(fileOutput);
            }
        }
    }

    private static InputStream loadTemplateImage(String imageTemplatePath) throws IOException {
        URL url = ResourceUtils.getURL(imageTemplatePath);
        return url.openStream();
    }
    
    public static List<CertificateVo> addTexts(String userName,String code,Certificate certificate) throws Exception{
    	ResourceBundle rb = ResourceBundle.getBundle("system");
    	
    	InputStream templateInput = null;
       
        templateInput = loadTemplateImage(rb.getString("file_path") + certificate.getUploadImage());
        Image image = ImageIO.read(templateInput);
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode request = mapper.readTree(certificate.getPosition());
        
        Calendar now = Calendar.getInstance();
    	String year = now.get(Calendar.YEAR) + "";
        String month = now.get(Calendar.MONTH) + 1 >=10 ? "" + (now.get(Calendar.MONTH) + 1) : "0" + (now.get(Calendar.MONTH) + 1);
        String day = now.get(Calendar.DATE) >=10 ? "" + now.get(Calendar.DATE) : "0" + now.get(Calendar.DATE);
        Map<String, String> data = new HashMap<>();
        data.put("name", userName);
        data.put("code", code);
        data.put("year", year);
        data.put("month", month);
        data.put("day", day);

    	List<CertificateVo> addTexts = Lists.newArrayList();
    	
        Iterator<JsonNode> its = request.elements();
        while (its.hasNext()) {
        	JsonNode json = its.next();
        	String name = json.get("name").asText();
        	Float x = json.get("x").floatValue()*imageWidth;
        	Float y = json.get("y").floatValue()*imageHeight;
        	
        	addTexts.add(new CertificateVo(data.get(name), new Font("宋体",Font.BOLD,50), Math.round(x), Math.round(y)+30));
        	
        }

//        addTexts.add(new CertificateVo(user.getName(),new Font("宋体",Font.BOLD,50),190,570));
//        addTexts.add(new CertificateVo(code,new Font("宋体",Font.PLAIN,30),270,1265));
//        addTexts.add(new CertificateVo(year,new Font("宋体",Font.PLAIN,30),525,1200));
//        addTexts.add(new CertificateVo(month,new Font("宋体",Font.PLAIN,30),650,1200));
//        addTexts.add(new CertificateVo(day,new Font("宋体",Font.PLAIN,30),740,1200));
    	return addTexts;
    }
    
    
	public static String get18Ic(String identifyCard) { 
		String retId = ""; 
		String id17 = ""; 
		int sum = 0; 
		int y = 0; // 定义数组加权因子 
		int[] wf = { 7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2 }; // 定义数组存放校验码 
		String[] cc = { "1", "0", "x", "9", "8", "7", "6", "5", "4", "3", "2" }; // 在原15位数身份证的第六位数后面插入19 
		id17 = identifyCard.substring(0, 6) + "19" + identifyCard.substring(6); // 17位数字和系数相乘，结果相加 
		for (int i = 0; i < 17; i++) { 
			sum = sum + Integer.valueOf(id17.substring(i, i + 1)) * wf[i]; 
		} // 计算余数 
		y = sum % 11; // 通过模获得对应的校验码cc[yy]; 
		retId = id17 + cc[y]; 
		return retId; 
		
	}
	public static void main(String[] args){
		System.out.print(get18Ic("120105850126422"));
	}
    

/*
    public static void main(String[] args){
        try {
//            GraphicsEnvironment ge=GraphicsEnvironment.getLocalGraphicsEnvironment();
//            String[] fa=ge.getAvailableFontFamilyNames();
//            for (String s:fa) {
//                System.out.println(s);
//            }
            List<CertificateVo> addTexts = Lists.newArrayList();
            Calendar now = Calendar.getInstance();
            String year = now.get(Calendar.YEAR) + "";
            String month = now.get(Calendar.MONTH) + 1 >=10 ? "" + (now.get(Calendar.MONTH) + 1) : "0" + (now.get(Calendar.MONTH) + 1);
            String day = now.get(Calendar.DATE) >=10 ? "" + now.get(Calendar.DATE) : "0" + now.get(Calendar.DATE);
            addTexts.add(new CertificateVo("刘扬",new Font("宋体",Font.BOLD,50),190,570));
            addTexts.add(new CertificateVo("02223456",new Font("宋体",Font.BOLD,30),270,1265));
            addTexts.add(new CertificateVo(year,new Font("宋体",Font.PLAIN,30),525,1200));
            addTexts.add(new CertificateVo(month,new Font("宋体",Font.PLAIN,30),650,1200));
            addTexts.add(new CertificateVo(day,new Font("宋体",Font.PLAIN,30),740,1200));
            UserUtils.generateCertificate("classpath:certificate.png","/Users/liuyang/Pictures/certificate.png",addTexts);
        }catch (IOException e){
            e.printStackTrace();;
        }

    }
*/
}
