package com.qiankun.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.qiankun.dao.GiftDao;
import com.qiankun.entity.Gift;

@Service
public class GiftService {

	@Autowired
	private GiftDao giftDao;
	
	public Gift findById(String id) {
		Gift gift = giftDao.find(id);
		return gift;
	}

	
	@Transactional
	public Gift save(Gift gift) {
		return giftDao.save(gift);		
	}
	
	@Transactional
	public void remove(String id) {
		giftDao.remove(id);
	}


	 public List<Gift> findAll() {
        List<Gift> list = giftDao.findAll();
        return list;
	}
	 
	 
 
}
