package com.qiankun.entity;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

import org.hibernate.annotations.GenericGenerator;

@Entity
public class Wish {
    public static final int STATUS_PUBLISH = 0;//发布心愿
    public static final int STATUS_RECEIVE = 1;//领取心愿
    public static final int STATUS_SEND = 2;//寄送礼物
    public static final int STATUS_HH_RECEIVE = 3;//红会代收
    public static final int STATUS_COMPLETE = 4;//红会寄出感谢卡或小朋友点圆梦
    public static final int HELP_TYPE_CUSTOM = 1;
    public static final int HELP_TYPE_EXPRESS = 2;
    @Id
    @GenericGenerator(name = "systemUUID", strategy = "uuid2")
    @GeneratedValue(generator = "systemUUID")
    private String id; //愿望ID
    private String title;//愿望标题
    private String content;//愿望内容
    private String uploadImage; //上传的图片
    private int status;//愿望状态,0:发布;1:领取;2.寄送中;3:红会代收;4:完成
    private String volunteerId; //领取愿望的爱心人士ID
    private String rainbowPlanUserId; //小朋友ID
    @ManyToOne
	private RainbowPlanUser children = new RainbowPlanUser();
    
    @ManyToOne
	private RainbowPlanUser volunteer = new RainbowPlanUser();
    
    @ManyToOne
	private Activity activity = new Activity();
    
    private Date createTime = new Date();
    private String activityId;//彩虹计划活动ID
    private int helpType;//0:无 1:自送礼物;2:快递
    private String expressCompany;//快递公司
    private String expressCode;//快递单号

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getRainbowPlanUserId() {
        return rainbowPlanUserId;
    }

    public void setRainbowPlanUserId(String rainbowPlanUserId) {
        this.rainbowPlanUserId = rainbowPlanUserId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getUploadImage() {
        return uploadImage;
    }

    public void setUploadImage(String uploadImage) {
        this.uploadImage = uploadImage;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getVolunteerId() {
        return volunteerId;
    }

    public void setVolunteerId(String volunteerId) {
        this.volunteerId = volunteerId;
    }

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public int getHelpType() {
        return helpType;
    }

    public void setHelpType(int helpType) {
        this.helpType = helpType;
    }

    public String getExpressCompany() {
        return expressCompany;
    }

    public void setExpressCompany(String expressCompany) {
        this.expressCompany = expressCompany;
    }

    public String getExpressCode() {
        return expressCode;
    }

    public void setExpressCode(String expressCode) {
        this.expressCode = expressCode;
    }

	public RainbowPlanUser getChildren() {
		return children;
	}

	public void setChildren(RainbowPlanUser children) {
		this.children = children;
	}

	public RainbowPlanUser getVolunteer() {
		return volunteer;
	}

	public void setVolunteer(RainbowPlanUser volunteer) {
		this.volunteer = volunteer;
	}

	public Activity getActivity() {
		return activity;
	}

	public void setActivity(Activity activity) {
		this.activity = activity;
	}

	
    
    
}
