var isSubmit = true;
$(document).ready(function(){
	$("#searchBtn").bind("click",function(){
		activity.search();
	});
	if ($('#activityForm').length>0){
		$('#activityForm').validate({
			
			rules : {
				"name" : {
					required : true					
				},
				"addr" : {
					required : true
				},
				"day" : {
					required : true
				},
				"max" : {
					required : true,
					isInteger: true
				},
				"crowd" : {
					required : true
				},
				"contacts" : {
					required : true
				},
				"tel": {
					required : true
				},
				"content" : {
					required : true
				}
				
				
				
			},
			messages:{
				"name" : {
					required : "不能为空"					
				},
				"addr" : {
					required : "不能为空"
				},
				"day" : {
					required : "不能为空"
				},
				"max" : {
					required : "不能为空"
				},
				"crowd" : {
					required : "不能为空"
				},
				"contacts" : {
					required : "不能为空"
				},
				"tel": {
					required : "不能为空"
				},
				"content" : {
					required : "不能为空"
				}

			},

	        
	        
	        submitHandler: function(form){  
	        	activity.save(form);
	        }
	        
	        
	        
		});
		
		
		laydate.render({
			  elem: '#day'
			  ,type: 'datetime'
			});
		
	}
	

	
	
	
	
	
})

var activity = {
	
	remove : function(count,id){
		if (count!=0){
			bootbox.dialog({
				message:"活动已有报名，不能删除",
					buttons:{
						"success":{
							"label":"确定",
							"className":"btn-sm btn-primary",
							"callback": function () {
								
	                        }
						}
					}
				});
		} else {
			bootbox.confirm({
				buttons: {
					cancel: {
						label: '取消',
						className: 'btn-default'
					},
					confirm: {
						label: '确认',
						className: 'btn-myStyle'
					}
					
				},
				message: '请确认是否删除?',
				callback: function(result) {
					if(result) {
						$.ajax({
							  type: 'GET',
							  url: webPath + '/api/activity/del?id='+id,
							  dataType:'json',
							  success: function(data){
								  window.location.reload();
							  }
						})
					} else {
						
					}
				},
				title: "删除活动"
			    });
		}
	},
	save : function(form){
		if (isSubmit){
			isSubmit = false;
						
			var formData = new FormData(); 
			formData.append('file', $('#input_file')[0].files[0]);
			formData.append('id', $('#id').val());
			formData.append('name', $('#name').val());
			formData.append('type', $('#type').val());
			formData.append('addr', $('#addr').val());
			formData.append('content', $('#content').val());
			formData.append('day', $('#day').val());
			formData.append('max', $('#max').val());
			formData.append('crowd', $('#crowd').val());
			formData.append('available', $('#available').val());
			formData.append('contacts', $('#contacts').val());
			formData.append('tel', $('#tel').val());
			
			

			$.ajax({
			    url: webPath + '/api/activity/save',
			    type: 'POST',
				cache: false,
				data: formData,
				processData: false,
				contentType: false,
				dataType:"json",
				beforeSend: function(){
				    
				},
				success: function(data){
				  var status=data.status;
				  
				  if(status==1){//成功
						bootbox.dialog({
							message:"新增活动成功",
								buttons:{
									"cancel":{
										"label":"返回",
										"className":"btn-sm btn-primary",
										"callback": function () {
											window.location.href = webPath + '/activity/list';
				                        }
									},
									"success":{
										"label":"继续添加",
										"className":"btn-sm btn-primary",
										"callback": function () {
											window.location.href = webPath + '/activity/add';
				                        }
									}
						
								}
							});
						
					} else if (status == 2){
						isSubmit = true;
						bootbox.dialog({
							message:"修改活动成功",
								buttons:{
									"success":{
										"label":"确定",
										"className":"btn-sm btn-primary",
										"callback": function () {
											window.location.reload();
				                        }
									}
						
								}
							});
						
						
					}
				  
				  
				}
			});
		}
			

		
	},
	search : function(){
		var type = $("#type").val();
		var searchStr = $("#searchStr").val();
		var url = webPath + "/activity/list";
		
		if(type!="" || searchStr!=""){
			var param = "?"
			if (type != ""){
				param = param + "type=" + type ;
			}
			
			if (searchStr != ""){
				if (param == "?"){
					param = param + "searchStr=" + searchStr;
				} else {
					param = param + "&searchStr=" + searchStr;
				}
				
			}
			url = url + param;
		}
		window.location.href = url;
	}
	
}


















