<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld"%>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld"%>

<head>


</head>
		

<div class="main-content">
	<div class="breadcrumbs" id="breadcrumbs">
		

		<ul class="breadcrumb">
			<li>
				<i class="icon-home home-icon"></i>
				<a href="#">首页</a>
			</li>
			<li class="active">彩虹计划</li>
			<li class="active">用户保存</li>
		</ul><!-- .breadcrumb -->

		
	</div>
	<div class="page-content">
		<div class="row">
		
			<div class="col-xs-12">
				
				<form action="#" id="userForm" name="userForm" method="post" onsubmit="return false" class="form-horizontal" role="form">
				<input type="hidden" id="id" name="id" value="${user.id}"/>
				<div class="row">
				<div class="col-xs-12">
				<h3 class="header smaller lighter blue">用户信息</h3></div>
				</div>
				
				
				<div class="row">
					<div class="col-xs-4">
						<div class="form-group">
							<label class="col-sm-3 control-label no-padding-right" for="form-field-1">  注册手机号 </label>
	
							<div class="col-sm-9">
								<input type="text" id=phone name="phone" value="${user.phone}" class="col-xs-10 col-sm-10" />
							  
							</div>
						</div>
						
						<div class="form-group">
							<label class="col-sm-3 control-label no-padding-right" for="form-field-1">  真实姓名 </label>
	
							<div class="col-sm-9">
								<input type="text" id="name" name="name" value="${user.name}" class="col-xs-10 col-sm-10" />
							  
							</div>
						</div>
					
						<c:if test="${user.type==0}">
						<div class="form-group">
							<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> <!--font color="red">*</font--> 昵称 </label>
	
							<div class="col-sm-9">
								<input type="text" id="nickName" name="nickName" value="${user.nickName}" class="col-xs-10 col-sm-10" />
							</div>
						</div>
						</c:if>
	
						
						<c:if test="${user.type==0}">
						<div class="form-group">
							<label class="col-sm-3 control-label no-padding-right" for="form-field-2"> 性别 </label>
	
							<div class="col-sm-9">
							
								<label>
									<input name="gender" type="radio" class="ace" value="1" <c:if test="${user.gender=='1'}">checked</c:if>>
									<span class="lbl"> 男</span>
								</label>
								<label>
									<input name="gender" type="radio" class="ace" value="2" <c:if test="${user.gender=='2'}">checked</c:if>>
									<span class="lbl"> 女</span>
								</label>							
									
							</div>
						</div>
						</c:if>
	
						
						<c:if test="${user.type==0}">
						<div class="form-group">
							<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly"> <!--font color="red">*</font--> 出生日期 </label>
	
							<div class="col-sm-9">
								<input class="col-xs-10 col-sm-10" id="birthday" name="birthday" type="text" autocomplete="off" data-date-format="yyyy/MM/dd" value="${user.birthday}"/>
								
							</div>
						</div>
						</c:if>
						
	
						
						<c:if test="${user.type==0}">
						<div class="form-group">
							<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly"> <!--font color="red">*</font--> 楼层床号 </label>
	
							<div class="col-sm-9">
								<input type="text" id="bedNum" name="bedNum" value="${user.bedNum}" class="col-xs-10 col-sm-10" />
								
							</div>
						</div>
						</c:if>
						
	
						
						<c:if test="${user.type==0}">
						<div class="form-group">
							<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly"> 疾病 </label>
	
							<div class="col-sm-9">
								<input type="text" id="disease" name="disease" value="${user.disease}" class="col-xs-10 col-sm-10" />
							</div>
						</div>
						</c:if>
						
					
						<div class="form-group">
							<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> <!--font color="red">*</font--> 收件人姓名</label>
	
							<div class="col-sm-9">
								<input type="text" id="receiveName" name="receiveName" value="${user.receiveName}" class="col-xs-10 col-sm-10" />
							</div>
						</div>
						
						
						<div class="form-group">
							<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly"> 联系方式</label>
	
							<div class="col-sm-9">
								<input type="text" id="connectTel" name="connectTel" value="${user.connectTel}" class="col-xs-10 col-sm-10" />
							</div>
						</div>
						
						
						<div class="form-group">
							<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 收件地址 </label>
	
							<div class="col-sm-9">
								<input type="text" id="receiveAddress" name="receiveAddress" value="${user.receiveAddress}" class="col-xs-10 col-sm-10" />
							</div>
						</div>
						
						<c:if test="${user.type==0}">
						<div class="form-group">
							<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 用户状态</label>
	
							<div class="col-sm-9">
								<select class="col-xs-10 col-sm-10" id="status" name="status">
									<option value="0" <c:if test="${user.status==0}">selected</c:if>>未审核</option>
									<option value="1" <c:if test="${user.status==1}">selected</c:if>>已审核</option>
									
								</select>
								
							</div>
						</div>
						</c:if>
						
						
						<div class="form-group">
							<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 头像</label>
	
							<div class="col-sm-9">
							<c:if test="${user.avatar!=null}">
								<img src="<webpath:path/>/wx/rainbowplan/loadResource?imageName=${user.avatar}" /></c:if>
								<input type="file" id="input_file" name="file" >
							</div>
						</div>
						
						
						
						
					
						
						
					
					</div>
				</div>
				
				
				<div class="col-md-offset-3 col-md-9">
					<button class="btn btn-sm btn-success" type="submit">
						<i class="icon-save bigger-110"></i>
						保存
					</button>

					&nbsp; &nbsp; &nbsp;
					<a class="btn btn-sm btn-success" href="javascript:history.go(-1)">
						<i class="icon-reply bigger-110"></i>
						返回
					</a>
				</div>
				
				
			</form>
			
			
											
											
										
			</div>
			
		</div>
	</div>
	
	
	
	
	
	
</div>

<script src="<webpath:path/>/resources/js/rainbow/rainbowuser.js" type="text/javascript"></script>
<script>
	user.type = ${user.type};
</script>

