<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld"%>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld"%>

<head>
	

</head>
		

<div class="main-content">
	<div class="breadcrumbs" id="breadcrumbs">
		

		<ul class="breadcrumb">
			<li>
				<i class="icon-home home-icon"></i>
				<a href="#">首页</a>
			</li>
			<li class="active">活动管理</li>
		</ul><!-- .breadcrumb -->

		
	</div>
	<div class="page-content">
		<div class="row">
		
			<div class="col-xs-12">
			<div class="widget-toolbox">
				<div class="btn-group">
					<button class="btn btn-sm btn-success" onclick="window.location.href='<webpath:path/>/activity/add'">
						<i class="icon-plus-sign-alt bigger-110"></i>
						新增
					</button>
					
					<!--  button class="btn btn-sm btn-success">
						<i class="icon-ban-circle bigger-110"></i>
						禁用
					</button-->
		
					
				</div>
				
				<div class="pull-right">
					
							<select class="" id="type" name="type">
									<option value="">请选择</option>
									<option value="1" <c:if test="${activityVo.type==1}">selected</c:if>>采血</option>
									<option value="2" <c:if test="${activityVo.type==2}">selected</c:if>>公益</option>
									<option value="3" <c:if test="${activityVo.type==3}">selected</c:if>>彩虹</option>
									<option value="4" <c:if test="${activityVo.type==4}">selected</c:if>>其他</option>
							</select>
						
							<input type="text" placeholder="查询" class="nav-search-input" id="searchStr" value="${activityVo.searchStr}" autocomplete="off">
							<a href="javascript:void(0);" id="searchBtn"><i class="icon-search nav-search-icon"></i></a>
						
						
				</div>
			</div>
			
			<div class="pull-left">共${activityPage.recordTotal}条</div>
				<table id="table-data" class="table table-bordered ">
					<thead>
						<tr class="">
							<!-- <th class="center">
								<label>
									<input type="checkbox" class="ace">
									<span class="lbl"></span>
								</label>
							</th> -->
							<th width="15%">活动名称</th>
							<th width="8%">活动类型</th>
							<th width="">活动地址</th>
							<th width="8%">活动时间</th>
							<th width="8%">最大人数</th>
							<th width="8%">适用人群</th>
							<th width="8%">联系人</th>
							<th width="8%">联系电话</th>
							<th width="8%" class="">状态</th>
							<th width="8%" class="">发布时间</th>
		
							<th width="100">操作</th>
						</tr>
					</thead>
		
					<tbody>
					
						<c:forEach var="activity" items="${activityPage.records}">
						<tr class="tr-highlight">
							<!-- <td class="center" width=10>
								<label>
									<input type="checkbox" class="ace">
									<span class="lbl"></span>
								</label>
							</td> -->
		
							<td title="">${activity.name}</td>
							<td title="">
								<c:if test="${activity.type==1}">采血</c:if>
								<c:if test="${activity.type==2}">公益</c:if>
								<c:if test="${activity.type==3}">彩虹</c:if>
								<c:if test="${activity.type==4}">其他</c:if>
							</td>
							<td title="">${activity.addr}</td>
							<td title="">${activity.day}</td>
							<td title=""><c:if test="${activity.type==3}">全部</c:if>
							<c:if test="${activity.type!=3}">
							<c:if test="${activity.max==0}">全部</c:if><c:if test="${activity.max!=0}">${activity.regCount}/${activity.max}</c:if>
							</c:if>
							</td>
							<td title="">
							<c:if test="${activity.crowd == 0}">全部</c:if>
							<c:if test="${activity.crowd == 1}">捐献志愿者</c:if>
							<c:if test="${activity.crowd == 2}">未采血用户</c:if>
							
							</td>
							<td title="">${activity.contacts}</td>
							<td title="">${activity.tel}</td>
							<td title=""> <c:if test="${activity.available}"><font color=green>正常</font></c:if><c:if test="${!activity.available}"><font color=red>关闭</font></c:if></td>
							<td title=""><fmt:formatDate value='${activity.createTime}' pattern='yyyy-MM-dd HH:mm' /></td>
							<td>
								<div class="visible-md visible-lg hidden-sm hidden-xs btn-group">
									<c:if test="${activity.type!=3}">
									<button class="btn btn-xs btn-info" title="报名情况" onclick="window.location.href='<webpath:path/>/activity/reg/list?activityId=${activity.id}'">
										<i class="icon-user"></i>
									</button>&nbsp;
									</c:if>
		
									<button class="btn btn-xs btn-info" onclick="window.location.href='<webpath:path/>/activity/add?id=${activity.id}'">
										<i class="icon-edit"></i>
									</button>
									&nbsp;
									<c:if test="${activity.type!=3}">
									<button class="btn btn-xs btn-danger " onclick="activity.remove('${activity.regCount}','${activity.id}')">
										<i class="icon-trash"></i>
									</button>
									</c:if>
		
									
									
									
								</div>
		
								
							</td>
						</tr>
						
						</c:forEach>
		
						
		
						
		
						
					</tbody>
				</table>
											
						<webpage:page totalCount="${activityPage.recordTotal}"
												pageCount="${pageCount}" currentPage="${pageNumber}"
												action="/activity/list"
												className="pageable-div pagination" 
												innerStyle=" float: left; width: 100%" /> 								
											
					
			</div>
			
		</div>
	</div>
	
	
	
	
	
	
</div>

<script src="<webpath:path/>/resources/js/activity/activity.js" type="text/javascript"></script>