package com.qiankun.dao;

import com.qiankun.dao.core.AbsDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.Activity;
import com.qiankun.entity.Blood;
import com.qiankun.entity.User;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class BloodDaoImpl extends AbsDao<Blood,String> implements BloodDao {
    @Override
    public long findCountByUserAndActivity(String userId, String activityId) {
        return findCount("select count(*) from Blood where user.id = ? and activity.id = ?",userId,activityId);
    }

    @Override
    public List<Blood> findByUserOrderByCreateTime(String userId) {
        return find(" from Blood where user.id = ? order by updateTime desc",new Hints(),userId);
    }
}
