package com.qiankun.dao;

import com.qiankun.dao.core.AbsDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.Activity;
import com.qiankun.entity.ActivityReg;
import com.qiankun.pages.IPageList;
import com.qiankun.pages.PageListImpl;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityRegDaoImpl extends AbsDao<ActivityReg,String> implements ActivityRegDao {
	
	private static final String FIND_ACTIVITYREG_PAGE = " from ActivityReg where activity.id = ?  ";
	
	@Override
	public IPageList<ActivityReg> findActivityRegPage(String searchStr, String activityId, String order, String sort, Hints hints) {
			
		if (order == null){
			order = " createTime ";
		}
		if (sort == null){
			sort=" desc ";
		}

		String hql = "";
    	if (StringUtils.isNotBlank(searchStr)) {
        	hql += " and (user.name like '%"+searchStr+"%' or user.mobile like '%"+searchStr+"%'  or user.paperId like '%"+searchStr+"%' )";       		
    	}
    		
		IPageList<ActivityReg> regs = new PageListImpl<ActivityReg>();
		
		regs.setRecords(find(FIND_ACTIVITYREG_PAGE + hql + sortHQL(order, sort), hints, activityId));
		regs.setRecordTotal(findCount(" select count(*) " + FIND_ACTIVITYREG_PAGE + hql, activityId));
		
		return regs;
	}
	
	@Override
	public void delByActivity(String activityId) {
		String hql="delete ActivityReg where activity.id=?";
		super.execUpdate(hql, activityId);
	}
	
	
}
