package com.qiankun.controller;
 
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qiankun.annotation.Auth;
import com.qiankun.controller.base.BaseController;
import com.qiankun.service.UserService;
 
@Controller
public class WebSiteController extends BaseController<Object>{
 
    @Autowired
    private ApplicationContext applicationContext;
    
    @RequestMapping("/default")
    public ModelAndView index() throws Exception {
        ModelAndView t_view = new ModelAndView();
        t_view.setViewName("index");
        return t_view;
    }
    
    @RequestMapping("/")
    public ModelAndView login() throws Exception {
        ModelAndView t_view = new ModelAndView();
        t_view.setViewName("index");
        return t_view;
    }
    

    @RequestMapping("/result")
    public ModelAndView search(String content) throws Exception {
        final UserService service = applicationContext.getBean(UserService.class);
        ModelAndView t_view = new ModelAndView();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode request = mapper.readTree(content);
		String condition = request.get("condition").asText();
		long interval = request.get("interval").asLong();
		long businessId = request.get("business").asLong();
		long startMs = request.get("start").asLong();
        
        return t_view;
    }
    
    
    @Auth(verifyLogin = false,verifyURL = false)
    @RequestMapping(value = "/api/dict",method = RequestMethod.GET)
    public @ResponseBody Map<String, Object> dictionary() throws Exception {
    	return this.dict();   	
    }

}