package com.qiankun.dao;

import com.qiankun.dao.core.AbsDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.RainbowPlanUser;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class RainbowPlanUserDaoImpl extends AbsDao<RainbowPlanUser,String> implements RainbowPlanUserDao {
    @Override
    public RainbowPlanUser findByOpenid(String openid) {
        return findUnique("from RainbowPlanUser where openid=?",new Hints(),openid);
    }

    @Transactional
    @Override
    public RainbowPlanUser save(RainbowPlanUser entity) {
        return super.save(entity);
    }

    @Transactional
    @Override
    public void update(RainbowPlanUser entity) {
        super.update(entity);
    }
}
