package com.qiankun.service;

import com.qiankun.dao.ActivityDao;
import com.qiankun.dao.ActivityRegDao;
import com.qiankun.dao.ActivityTypeDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.Activity;
import com.qiankun.entity.ActivityReg;
import com.qiankun.entity.ActivityType;
import com.qiankun.pages.IPageList;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.awt.image.RGBImageFilter;
import java.text.BreakIterator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@Service
public class ActivityService {

	@Autowired
	private ActivityDao activityDao;
	@Autowired
	private ActivityRegDao activityRegDao;
	
	@Autowired
	private ActivityTypeDao activityTypeDao;
	
	public Activity findById(String id) {
		Activity activity = activityDao.find(id);
		return activity;
	}
	
	
	@Transactional
	public Activity save(Activity activity) {
		return activityDao.save(activity);		
	}
	
	@Transactional
	public void remove(String id) {
		activityDao.remove(id);
	}

	public IPageList<Activity> findByActivitys(String searchStr,String type,String order,String sort, Hints hints){
		IPageList<Activity> activitys = activityDao.findActivityPage(searchStr, type, order, sort, hints);
		return activitys;
	}

	 public List<Activity> findByAavailableAndType(Boolean available, String type) {
        List<Activity> activities = activityDao.findByAvailableAndType(available,type);
        return activities;
	}
	 
	 
    public Activity findByAavailableAndType(String type) {
        List<Activity> activities = activityDao.findByAvailableAndType(true,type);
        if (!CollectionUtils.isEmpty(activities)){
            return activities.get(0);
        }
        return null;
    }
	
	
	@Transactional
	public ActivityType saveType(ActivityType type) {
		return activityTypeDao.save(type);		
	}
	
	@Transactional
	public void removeType(String id) {
		activityTypeDao.remove(id);
	}
	
	public List<ActivityType> findActivitysTypes(){
		return activityTypeDao.findAll();
	}
	
	public ActivityType findTypeById(String id) {
		ActivityType type = activityTypeDao.find(id);
		return type;
	}

    @Transactional
    public void saveActivityReg(ActivityReg reg) {
	    activityRegDao.save(reg);
    }

    @Transactional
    public ActivityReg signin(String userId, String activityId) {
	    Activity activity = findById(activityId);
        Iterator<ActivityReg> it = activity.getActivityReg().iterator();
        ActivityReg rt = null;
        while (it.hasNext()){
            ActivityReg reg = it.next();
            if (reg.getUser().getId().equals(userId)){
                reg.setSignin(true);
                reg.setSigninTime(new Date());
                saveActivityReg(reg);
                rt = reg;
            }
        }
        return rt;
    }
    @Transactional
    public ActivityReg signout(String userId, String activityId) {
        Activity activity = findById(activityId);
        Iterator<ActivityReg> it = activity.getActivityReg().iterator();
        ActivityReg rt = null;
        while (it.hasNext()){
            ActivityReg reg = it.next();
            if (reg.getUser().getId().equals(userId)){
                reg.setSignoutTime(new Date());
                saveActivityReg(reg);
                rt = reg;
            }
        }
        return rt;
    }

    public IPageList<Activity> findPageList(String userId, Hints hints) {
	    return activityDao.findPageList(userId,hints);
    }
}
