package com.qiankun.dao;

import com.qiankun.dao.core.AbsDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.WishReply;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository
public class WishReplyDaoImpl extends AbsDao<WishReply,String> implements WishReplyDao {
    @Override
    public List<WishReply> findByWishId(String wishId) {
        return find("from WishReply where wishId = ? order by createTime asc",new Hints(0),wishId);
    }

    @Transactional
    @Override
    public WishReply save(WishReply entity) {
        return super.save(entity);
    }
}
