<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld"%>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld"%>

<head>
	

</head>
		

<div class="main-content">
	<div class="breadcrumbs" id="breadcrumbs">
		

		<ul class="breadcrumb">
			<li>
				<i class="icon-home home-icon"></i>
				<a href="#">首页</a>
			</li>
			<li class="active">活动管理</li>
		</ul><!-- .breadcrumb -->

		
	</div>
	<div class="page-content">
		<div class="row">
		
			<div class="col-xs-12">
			<div class="widget-toolbox">
				<div class="btn-group">
					<button class="btn btn-sm btn-success" onclick="window.location.href='<webpath:path/>/activity/add'">
						<i class="icon-plus-sign-alt bigger-110"></i>
						新增
					</button>
					
					<button class="btn btn-sm btn-success">
						<i class="icon-star-half-full bigger-110"></i>
						禁用
					</button>
		
					<button class="btn btn-sm btn-danger">
						<i class="icon-trash bigger-110"></i>
						删除
					</button>
				</div>
			</div>
			
			<div class="pull-left">共条</div>
				<table id="table-data" class="table table-bordered ">
					<thead>
						<tr class="">
							<th class="center">
								<label>
									<input type="checkbox" class="ace">
									<span class="lbl"></span>
								</label>
							</th>
							<th>活动名称</th>
							<th>活动类型</th>
							<th>活动地址</th>
							<th>活动时间</th>
							<th>最大人数</th>
							<th>适用人群</th>
							<th>联系人</th>
							<th>联系电话</th>
							<th class="hidden-480">状态</th>
		
							<th width="100">操作</th>
						</tr>
					</thead>
		
					<tbody>
					
						<c:forEach var="activity" items="${activityPage.records}">
						<tr class="tr-highlight">
							<td class="center" width=10>
								<label>
									<input type="checkbox" class="ace">
									<span class="lbl"></span>
								</label>
							</td>
		
							<td title="">${activity.name}</td>
							<td title="">${activity.type}</td>
							<td title="">${activity.addr}</td>
							<td title=""><fmt:formatDate value='${activity.day}' pattern='yyyy-MM-dd HH:mm' /></td>
							<td title="">${activity.max}</td>
							<td title="">${activity.crowd}</td>
							<td title="">${activity.contacts}</td>
							<td title="">${activity.tel}</td>
							<td title=""> <c:if test="${activity.available}"><font color=green>正常</font></c:if><c:if test="${!activity.available}"><font color=red>关闭</font></c:if></td>
							
							<td>
								<div class="visible-md visible-lg hidden-sm hidden-xs btn-group">
									
		
									<button class="btn btn-xs btn-info" onclick="window.location.href='<webpath:path/>/activity/add?id=${activity.id}'">
										<i class="icon-edit bigger-120"></i>
									</button>
									&nbsp;
		
									<button class="btn btn-xs btn-danger">
										<i class="icon-trash bigger-120"></i>
									</button>
		
									
								</div>
		
								
							</td>
						</tr>
						
						</c:forEach>
		
						
		
						
		
						
					</tbody>
				</table>
											
											
											
					
			</div>
			
		</div>
	</div>
	
	
	
	
	
	
</div>

