package com.qiankun.entity;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.OneToMany;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import com.fasterxml.jackson.annotation.JsonIgnore;

@Entity
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
@Inheritance(strategy = InheritanceType.TABLE_PER_CLASS)
public class User {

	@Id
	@GenericGenerator(name = "systemUUID", strategy = "uuid2")
	@GeneratedValue(generator = "systemUUID")
	private String id;
    
	private String userName;
    private String userCode; 	  //用户二维码
    private String name;          //姓名
    private String gender;		//性别
    private String birthday;	//出生年月
    private String paperType;    //证件类型     1.身份证
    private String paperId;    //证件号
    private String nation;     //民族
    private String nativePlace;  //籍贯
    private String nationality;  //国籍
    private String education;    //学历
    private String domicilePlace; //户籍所在地
    private String addr;		//经常居住地
    private String unit;		//单位、学校
    private String unitAddr;	//单位、学校地址
    private String unitTel;	    //单位、学校电话
    private String profession;	//职业

    private String mobile;		  //本人手机
    private String email;		//邮箱
    private String tel;			  //固定电话
    private String qq;
    private String weixin;      //微信号
    private String openid;		//微信openid
    private Integer donateBloodCount;  //无偿献血次数
    private String bloodType;  //血型
    private Integer height;    //身高
    private Integer weight;    //体重
    
    @Lob
    private String remark;	//备注
    
    private String origin;  //用户来源
    private String referrals;  //推荐人

    private String pwd;           //密码
    
    private String role;    	  //角色     1.管理员   2.志愿者  
    private String status;		//状态    0.未采血    1.已采血
    
    private Date createTime = new Date();
    private Date updateTime = new Date();

    @OneToMany(fetch = FetchType.LAZY, cascade = { CascadeType.ALL}, orphanRemoval = true, mappedBy = "user")
	@JsonIgnore
	private Set<Contacts> contacts = new HashSet<Contacts>();
    
    @OneToMany(fetch = FetchType.LAZY, cascade = { CascadeType.ALL}, orphanRemoval = true, mappedBy = "user")
   	@JsonIgnore
   	private Set<Blood> blood = new HashSet<Blood>();
    
    @OneToMany(fetch = FetchType.LAZY, cascade = { CascadeType.ALL}, orphanRemoval = true, mappedBy = "review")
   	@JsonIgnore
   	private Set<Blood> review = new HashSet<Blood>();
    
    @OneToMany(fetch = FetchType.LAZY, cascade = { CascadeType.ALL}, orphanRemoval = true, mappedBy = "user")
	@JsonIgnore
	private Set<Points> points = new HashSet<Points>();
    
    
    private Boolean isRemove=false;//是否删除用户,默认false
    
    
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}

	public String getMobile() {
		return mobile;
	}
	public void setMobile(String mobile) {
		this.mobile = mobile;
	}
	public String getPwd() {
		return pwd;
	}
	public void setPwd(String pwd) {
		this.pwd = pwd;
	}

	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public String getRole() {
		return role;
	}
	public void setRole(String role) {
		this.role = role;
	}
	public Date getCreateTime() {
		return createTime;
	}
	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
	public Set<Contacts> getContacts() {
		return contacts;
	}
	public void setContacts(Set<Contacts> Contacts) {
		this.contacts = Contacts;
	}
	public Boolean getIsRemove() {
		return isRemove;
	}
	public void setIsRemove(Boolean isRemove) {
		this.isRemove = isRemove;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getGender() {
		return gender;
	}
	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getBirthday() {
		return birthday;
	}
	public void setBirthday(String birthday) {
		this.birthday = birthday;
	}
	public String getPaperType() {
		return paperType;
	}
	public void setPaperType(String paperType) {
		this.paperType = paperType;
	}
	public String getPaperId() {
		return paperId;
	}
	public void setPaperId(String paperId) {
		this.paperId = paperId;
	}
	public String getNation() {
		return nation;
	}
	public void setNation(String nation) {
		this.nation = nation;
	}
	public String getNativePlace() {
		return nativePlace;
	}
	public void setNativePlace(String nativePlace) {
		this.nativePlace = nativePlace;
	}
	public String getNationality() {
		return nationality;
	}
	public void setNationality(String nationality) {
		this.nationality = nationality;
	}
	public String getEducation() {
		return education;
	}
	public void setEducation(String education) {
		this.education = education;
	}
	public String getDomicilePlace() {
		return domicilePlace;
	}
	public void setDomicilePlace(String domicilePlace) {
		this.domicilePlace = domicilePlace;
	}
	public String getAddr() {
		return addr;
	}
	public void setAddr(String addr) {
		this.addr = addr;
	}
	public String getUnit() {
		return unit;
	}
	public void setUnit(String unit) {
		this.unit = unit;
	}
	public String getUnitAddr() {
		return unitAddr;
	}
	public void setUnitAddr(String unitAddr) {
		this.unitAddr = unitAddr;
	}
	public String getUnitTel() {
		return unitTel;
	}
	public void setUnitTel(String unitTel) {
		this.unitTel = unitTel;
	}
	public String getProfession() {
		return profession;
	}
	public void setProfession(String profession) {
		this.profession = profession;
	}
	public String getTel() {
		return tel;
	}
	public void setTel(String tel) {
		this.tel = tel;
	}
	public String getQq() {
		return qq;
	}
	public void setQq(String qq) {
		this.qq = qq;
	}

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public Integer getDonateBloodCount() {
		return donateBloodCount;
	}
	public void setDonateBloodCount(Integer donateBloodCount) {
		this.donateBloodCount = donateBloodCount;
	}
	public String getBloodType() {
		return bloodType;
	}
	public void setBloodType(String bloodType) {
		this.bloodType = bloodType;
	}
	public Integer getHeight() {
		return height;
	}
	public void setHeight(Integer height) {
		this.height = height;
	}
	public Integer getWeight() {
		return weight;
	}
	public void setWeight(Integer weight) {
		this.weight = weight;
	}
	public String getRemark() {
		return remark;
	}
	public void setRemark(String remark) {
		this.remark = remark;
	}
	public Set<Blood> getBlood() {
		return blood;
	}
	public void setBlood(Set<Blood> blood) {
		this.blood = blood;
	}
	public Set<Blood> getReview() {
		return review;
	}
	public void setReview(Set<Blood> review) {
		this.review = review;
	}
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}
	public Set<Points> getPoints() {
		return points;
	}
	public void setPoints(Set<Points> points) {
		this.points = points;
	}
	public String getWeixin() {
		return weixin;
	}
	public void setWeixin(String weixin) {
		this.weixin = weixin;
	}
	public String getUserCode() {
		return userCode;
	}
	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public Date getUpdateTime() {
		return updateTime;
	}
	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}
	public String getOrigin() {
		return origin;
	}
	public void setOrigin(String origin) {
		this.origin = origin;
	}
	public String getReferrals() {
		return referrals;
	}
	public void setReferrals(String referrals) {
		this.referrals = referrals;
	}


    
    
}
