<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld"%>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld"%>

<head>
	

</head>
		

<div class="main-content">
	<div class="breadcrumbs" id="breadcrumbs">
		

		<ul class="breadcrumb">
			<li>
				<i class="icon-home home-icon"></i>
				<a href="#">首页</a>
			</li>
			<li class="active">用户管理</li>
		</ul><!-- .breadcrumb -->

		
	</div>
	<div class="page-content">
		<div class="row">
		
			<div class="col-xs-12">
			<div class="widget-toolbox">
				<div class="btn-group">
					<button class="btn btn-sm btn-success" onclick="window.location.href='<webpath:path/>/user/add'">
						<i class="icon-plus-sign-alt bigger-110"></i>
						新增
					</button>
					
					<button class="btn btn-sm btn-success" onclick="window.location.href='<webpath:path/>/user/importpage'">
						<i class="icon-star-half-full bigger-110"></i>
						导入
					</button>
					
					<button class="btn btn-sm btn-success" onclick="window.location.href='<webpath:path/>/user/exportpage'">
						<i class="icon-star-half-full bigger-110"></i>
						导出
					</button>
					
		
					
					
				</div>
				
				<div class="pull-right">
					
					
							<select class="" id="role" name="role">
									<option value="">请选择</option>
									<option value="2" <c:if test="${userVo.role==2}">selected</c:if>>普通用户</option>
									<option value="1" <c:if test="${userVo.role==1}">selected</c:if>>管理员</option>
							</select>
						  
						
							<select class="" id="status" name="status">
									<option value="">请选择</option>
									<option value="1" <c:if test="${userVo.status==1}">selected</c:if>>未采血</option>
									<option value="2" <c:if test="${userVo.status==2}">selected</c:if>>已采血</option>
									<option value="3" <c:if test="${userVo.status==3}">selected</c:if>>已退库</option>
									<option value="4" <c:if test="${userVo.status==4}">selected</c:if>>再采血</option>
							</select>
						
							<input type="text" placeholder="查询" class="nav-search-input" id="searchStr" value="${userVo.searchStr}" autocomplete="off">
							<a href="javascript:void(0);" id="searchBtn"><i class="icon-search nav-search-icon"></i></a>
						
						
				</div>
			</div>
			
			<div class="pull-left">共${userPage.recordTotal}条</div>
				<table id="table-data" class="table table-bordered ">
					<thead>
						<tr class="">
							<!-- <th class="center">
								<label>
									<input type="checkbox" class="ace">
									<span class="lbl"></span>
								</label>
							</th> -->
							<th>姓名</th>
							<th>性别</th>
							<th>出生年月</th>
							
							
							<th>籍贯</th>
							<th>证件</th>
							<th>证件号</th>
							<th>手机号</th>
							<th>角色</th>
							
							<th><i class="icon-time bigger-110 hidden-480"></i>注册时间</th>
							<th class="hidden-480">状态</th>
		
							<th width="100">操作</th>
						</tr>
					</thead>
		
					<tbody>
					
						<c:forEach var="user" items="${userPage.records}">
						<tr class="tr-highlight">
							<!-- <td class="center" width=10>
								<label>
									<input type="checkbox" class="ace">
									<span class="lbl"></span>
								</label>
							</td> -->
		
							<td title="${user.name}">${user.name} </td>
							<td title="${user.gender}">${user.gender}</td>
							<td title="${user.birthday}">${user.birthday} </td>
							<td title="${user.nativePlace}">${user.nativePlace} </td>
							<td title="${user.paperType}">${user.paperType} </td>
							
							<td title="${user.paperId}">${user.paperId} </td>
							<td title="${user.mobile}">${user.mobile} </td>
							<td >
							<c:if test="${user.role==1}">
                            	管理员
                            </c:if>
                            <c:if test="${user.role==2}">
                            	普通用户
                            </c:if>
							</td>
							<td title="<fmt:formatDate value='${user.createTime}' pattern='yyyy-MM-dd HH:mm' />"><fmt:formatDate value='${user.createTime}' pattern='yyyy-MM-dd HH:mm' /> </td>
		
							<td>
							 	<c:if test="${user.status==1 || user.status==null}">
								<span class="label label-sm label-warning">未采血</span>
								</c:if>
								<c:if test="${user.status==2}">
								<span class="label label-sm label-success">已采血</span>
								</c:if>
								
								<c:if test="${user.status==3}">
								<span class="label label-sm label-danger">已退库</span>
								</c:if>
								
								<c:if test="${user.status==4}">
								<span class="label label-sm label-primary">再采血</span>
								</c:if>
							</td>
		
							<td>
								<div class="visible-md visible-lg hidden-sm hidden-xs btn-group">
									
		
									<button class="btn btn-xs btn-info" onclick="window.location.href='<webpath:path/>/user/add?id=${user.id}'">
										<i class="icon-edit bigger-120"></i>
									</button>
									&nbsp;
		
									<button class="btn btn-xs btn-danger" onclick="user.del('${user.id}')">
										<i class="icon-trash bigger-120"></i>
									</button>
		
									
								</div>
		
								
							</td>
						</tr>
						</c:forEach>
						
		
						
		
						
		
						
					</tbody>
				</table>
											
											
											
					<webpage:page totalCount="${userPage.recordTotal}"
												pageCount="${pageCount}" currentPage="${pageNumber}"
												action="/user/list"
												className="pageable-div pagination" 
												innerStyle=" float: left; width: 100%" /> 						
			</div>
			
		</div>
	</div>
	
	
	
	
	
	
</div>
<script src="<webpath:path/>/resources/js/user/user.js" type="text/javascript"></script>
