package com.qiankun.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.qiankun.dao.PointsTypeDao;
import com.qiankun.entity.Points;

@Service
public class PointsService {

	@Autowired
	private PointsTypeDao typeDao;
	
	public Points findById(String id) {
		Points type = typeDao.find(id);
		return type;
	}

	
	@Transactional
	public Points saveType(Points type) {
		return typeDao.save(type);		
	}
	
	@Transactional
	public void removeType(String id) {
		typeDao.remove(id);
	}


	 public List<Points> findAllType() {
        List<Points> list = typeDao.findAll();
        return list;
	}
	 
	 
 
}
