package com.qiankun.entity;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import com.fasterxml.jackson.annotation.JsonIgnore;

@Entity
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
@Inheritance(strategy = InheritanceType.TABLE_PER_CLASS)
public class Blood {

	@Id
	@GenericGenerator(name = "systemUUID", strategy = "uuid2")
	@GeneratedValue(generator = "systemUUID")
	private String id;
	
	private String bloodId;    //采样编号
	
	private String bloodCollect;  //采血者
	
	@Lob
	private String bloodAddr;     //采血地点

	private String review;  //数据初审者;
	
	@ManyToOne
	private User user = new User();
	@ManyToOne
	private Activity activity = null;
	
	private Date updateTime = new Date();

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getBloodId() {
		return bloodId;
	}

	public void setBloodId(String bloodId) {
		this.bloodId = bloodId;
	}

	public String getBloodAddr() {
		return bloodAddr;
	}

	public void setBloodAddr(String bloodAddr) {
		this.bloodAddr = bloodAddr;
	}
	
	public String getReview() {
		return review;
	}

	public void setReview(String review) {
		this.review = review;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

    public Activity getActivity() {
        return activity;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

	public String getBloodCollect() {
		return bloodCollect;
	}

	public void setBloodCollect(String bloodCollect) {
		this.bloodCollect = bloodCollect;
	}
    
    
}
