package com.qiankun.dao;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.qiankun.dao.core.AbsDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.User;
import com.qiankun.pages.IPageList;
import com.qiankun.pages.PageListImpl;

@Repository
public class UserDaoImpl extends AbsDao<User, String> implements UserDao {
	
	private static final String FIND_USER_PAGE = " from User where (mobile like ? or paperId like ? or name like ? or userName like ?)  and remove=false ";
	
//	private static final String FIND_LASTUSER_BY_GROUP = " from User where groups = ? order by createTime desc";
	
	private static final String LOGIN = " from User where mobile = ? and pwd = ? and remove=false";
	
	private static final String VALIDATE_PAPERID = " from User where paperId = ?";
	
	private static final String VALIDATE_USERNAME = " from User where userName = ?";
	
	private static final String VALIDATE_PWD = " from User where id = ? and pwd = ? and remove=false ";
	private static final String FIND_BY_OPENID = "from User where openid = ? and remove=false ";
	private static final String FIND_BY_PAPERID_PAPERTYPE = "from User where paperId = ? and paperType = ? and remove=false ";
	
	private static final String FIND_BY_PAPERID = "from User where paperId = ? ";
	
	private static final String FIND_USER_PAGE_EXPORT = " select user from User user join user.blood blood where remove=false ";
	
	@Override
	public Boolean validateUserExistByPaperId(String paperId) {
		Long count = findCount(" select count(*) " + VALIDATE_PAPERID, paperId);
		if (count > 0)
			return true;
		else
			return false;
	}
	
	@Override
	public Boolean validateUserExistByUserName(String userName) {
		Long count = findCount(" select count(*) " + VALIDATE_USERNAME, userName);
		if (count > 0)
			return true;
		else
			return false;
	}


	
//	@Override
//	public User findLastUserByGroup(String groupId) {
//		
//		List<User> records = find(FIND_LASTUSER_BY_GROUP , new Hints(0,1),  groupId);
//		if (records.size()>0) {
//			return records.get(0);
//		} else {
//			return null;
//		}
//		
//		
//	}
	
	
	@Override
	public List<User> findUserPage(String name, String paperId, String start, String end, String bloodId, String startbloodId, String endbloodId, String order, String sort, Hints hints) {
		
		if (order == null){
			order = " user.createTime ";
		}
		if (sort == null){
			sort=" desc ";
		}
		
		String hql = "";
		if (name != null){
			hql +=  " and user.name = '" +name+ "' ";
		}
		
		if (paperId != null){
			hql += " and user.paperId = '" +paperId+ "' ";
		}
		
		if (bloodId != null){
			hql += " and blood.bloodId = '" +bloodId+ "' ";
		}
		
		if (startbloodId != null){
			hql += " and blood.bloodId > '" +startbloodId+ "' ";
		}
		
		if (endbloodId != null){
			hql += " and blood.bloodId < '" +endbloodId+ "' ";
		}
		
		
		if (start != null){
			hql += " and blood.updateTime > '" +start+ "' ";
		}
		
		if (end != null){
			hql += " and blood.updateTime < '" +end+ "' ";
		}

		return find(FIND_USER_PAGE_EXPORT + hql + sortHQL(order, sort), hints);
	}	
	
	
	@Override
	public User login(String mobile, String password) {
		return findUnique(LOGIN, new Hints(), mobile, password);
	}
	
	@Override
	public Boolean validatePwd(String id, String password) {
		Long count = findCount(" select count(*) " + VALIDATE_PWD, id, password);
		if (count > 0)
			return true;
		else
			return false;
		
	}

    @Override
    public User findByOpenid(String openid) {
        return findUnique(FIND_BY_OPENID,new Hints(),openid);
    }

    @Override
    public User findByPaperId(String paperId, String paperType) {
        return findUnique(FIND_BY_PAPERID_PAPERTYPE,new Hints(),paperId,paperType);
    }
    
    @Override
    public User findByPaperId(String paperId) {
        return findUnique(FIND_BY_PAPERID,new Hints(),paperId);
    }
    
    
    @Override
	public IPageList<User> findUserPage(String searchStr, String role, String status,String order, String sort, Hints hints) {
		
		if (order == null){
			order = " createTime ";
		}
		if (sort == null){
			sort=" desc ";
		}
		
		String hql = "";
		if (role != null){
			hql +=  " and role = '" +role+ "' ";
		}
		
		if (status != null){
			hql += " and status = '" +status+ "' ";
		}
		
		if (searchStr == null) {
			searchStr = "%";
		}
		String param = "%" + searchStr + "%";
		IPageList<User> users = new PageListImpl<User>();
		users.setRecords(find(FIND_USER_PAGE + hql + sortHQL(order, sort), hints, param, param, param, param));
		users.setRecordTotal(findCount(" select count(*) " + FIND_USER_PAGE + hql, param, param, param, param));
		
		
		return users;
	}	
}
