package com.qiankun.dao;

import java.util.List;

import com.qiankun.dao.core.Hints;
import com.qiankun.dao.core.IDao;
import com.qiankun.entity.User;
import com.qiankun.pages.IPageList;

public interface UserDao extends IDao<User, String> {

    User findByPaperId(String paperId, String paperType);

    IPageList<User> findUserPage(String searchStr, String role, String status, String order, String sort, Hints hints);

	User login(String userName, String password);

	Boolean validateUserExistByPaperId(String mobile);

	Boolean validatePwd(String id, String password);

	Boolean validateUserExistByUserName(String userName);

    User findByOpenid(String openid);

	User findByPaperId(String paperId);

	List<User> findUserPage(String name, String paperId, String start, String end, String bloodId,
			String startbloodId, String endbloodId, String order, String sort, Hints hints);
}
