package com.qiankun.controller;
 
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import com.qiankun.controller.base.BaseController;
import com.qiankun.entity.Points;
import com.qiankun.service.PointsService;
 
@Controller
public class PointsController extends BaseController<Object>{
 
	@Autowired
	private PointsService pointsService;
    
    @RequestMapping("/points/type/list")
    public ModelAndView list(HttpServletResponse response, HttpServletRequest request) throws Exception {
        ModelAndView view = new ModelAndView();
		view.getModelMap().addAttribute("typelist", pointsService.findAllType());
        view.setViewName("points/typelist");
        return view;
    }
    
    
    @RequestMapping("/points/type/add")
    public ModelAndView typeAdd(String id) throws Exception {
        ModelAndView view = new ModelAndView();  
        Points type = new Points();
        if(StringUtils.isNotBlank(id)) {
        	type = pointsService.findById(id);      
        }
         
        view.setViewName("points/savetype");
        view.getModel().put("type", type);
        return view;
    }
    
    @RequestMapping("/points/type/save")
	public ModelAndView saveType(Points type, HttpServletResponse response, HttpServletRequest request) throws Exception {
    	ModelAndView view = new ModelAndView();
    	if (StringUtils.isNotEmpty(type.getId())) {
    		Points t = pointsService.findById(type.getId());
    		t.setAvailable(type.isAvailable());
    		t.setId(type.getId());
    		t.setName(type.getName());
    		t.setPoint(type.getPoint());
    		view.getModelMap().addAttribute("status", 2);
    	} else {    		
    		pointsService.saveType(type);
    		view.getModelMap().addAttribute("status", 1);
    	}
    	return view;
    	
    }
    
    @RequestMapping("/points/type/del")    
    public ModelAndView delActivity(String id,  HttpServletResponse response, HttpServletRequest request) throws Exception {
    	ModelAndView view = new ModelAndView();
    	pointsService.removeType(id);
    	return view;
    }
    
  
}