$(document).ready(function(){
	
	if ($('#userForm').length>0){
		$('#userForm').validate({
			doNotHideMessage : true, //this option enables to show the error/success messages on tab switch.
			errorElement : 'span', //default input error message container
			errorClass : 'validate-inline', // default input error message class
			focusInvalid : false, // do not focus the last invalid input
			rules : {
				"firstName" : {
					required : true					
				},
				"lastName" : {
					required : true
				},
				"roleId" : {
					required : true
				},
				"email" : {
					required : true,
					email	 : true
				},
				"password" : {
					required : "#changePassword:checked"
				},
				"confirm_password" : {
					required : "#changePassword:checked",
					equalTo: "#password"
				},
				"roleId": {
					required : true
				},
				"jobNumber" : {
					required : "#isEmployee:checked"
				},
				"hireOnDateValue" : {
					required : "#isEmployee:checked"
				},
				
				"clockId" : {
					required : "#isEmployee:checked",
					number : "#isEmployee:checked",
					min : 1
				},
				"payId" : {
					required : "#isEmployee:checked"
				},
				"paygroupId" : {
					required : "#isEmployee:checked"
				},
				"departmentValue" : {
					required : true
				}
				
				
			},


	        errorPlacement: function (error, element) { // render error placement for each input type
	            error.insertAfter(element); // for other inputs, just perform default behavoir
	            
	            if (element.attr("name") == "roleId") {
	            	$("#roleId-controls div a").attr("style","border-color: #b94a48 !important");
	            }
	        },

	        invalidHandler: function (event, validator) { //display error alert on form submit   
	        	parent.Loading.stop();
	        	
	        },

	        highlight: function (element) { // hightlight error inputs
	            $(element).closest('.help-inline').removeClass('ok'); // display OK icon
	            $(element).closest('.control-group').removeClass('success').addClass('error'); // set error class to the control group
	        },

	        unhighlight: function (element) { // revert the change dony by hightlight
	            $(element).closest('.control-group').removeClass('error'); // set error class to the control group
	            if ($(element).attr("name") == "roleId") {
	            	$("#roleId-controls div a").attr("style","");
	            }
	        },

	        success: function (label) {
	            label.addClass('valid').closest('.control-group').removeClass('error'); // set success class to the control group
	            label.remove();
	            
	        },
	        
	        submitHandler: function(form){  
	        	user.save(form,false);
	        },
	        
	        onfocusin: function( element, event ) {
	        	
	        }
	        
		});
		
	}
	

	
	$('#birthday').datepicker()
	
	$("#nation").select2({
		placeholder : "请选择",
		allowClear : true
	});
	
	$("#nativePlace").select2({
		placeholder : "请选择",
		allowClear : true
	});

	
/*	$("#domicilePlace").hsCheckData({
        isShowCheckBox: false, //默认为false
        data: cityData
    });*/
	
	
})

var user = {
	
	save : function(form){
		
		
	}
	
}


















