package com.qiankun.utils;

import com.google.common.collect.Lists;
import com.qiankun.entity.Contacts;
import com.qiankun.entity.User;
import com.qiankun.vo.CertificateVo;
import com.qiankun.vo.UserVo;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URL;
import java.util.*;
import java.util.List;

public class UserUtils {

    public static UserVo converToVo(User user){
        UserVo vo = null;
        if (user != null){
            vo = new UserVo();
            BeanUtils.copyProperties(user,vo);
            Set<Contacts> contacts = user.getContacts();
            if (contacts != null){
                Iterator<Contacts> its = contacts.iterator();
                Integer count = 0;
                while (its.hasNext()) {
                    Contacts c = its.next();
                    if (count == 0) {
                        vo.setContactsAddr1(c.getAddr());
                        vo.setContactsName1(c.getName());
                        vo.setContactsMobile1(c.getMobile());
                        vo.setContactsRelation1(c.getRelation());
                        vo.setContactsWeixin1(c.getWeixin());
                        vo.setContactsQQ1(c.getQq());
                        count ++;
                    } else {
                        vo.setContactsAddr2(c.getAddr());
                        vo.setContactsName2(c.getName());
                        vo.setContactsMobile2(c.getMobile());
                        vo.setContactsRelation2(c.getRelation());
                        vo.setContactsWeixin2(c.getWeixin());
                        vo.setContactsQQ2(c.getQq());
                    }


                }
            }

        }
        return vo;
    }
    public static void generateCertificate(String imageTemplatePath, String outputImagePath, List<CertificateVo> addTexts) throws IOException {
        InputStream templateInput = null;
        FileOutputStream fileOutput = null;
        try {
            templateInput = loadTemplateImage(imageTemplatePath);
            Image image = ImageIO.read(templateInput);
            int imageWidth = image.getWidth(null);
            int imageHeight = image.getHeight(null);

            BufferedImage bufferedImage = new BufferedImage(imageWidth,imageHeight,BufferedImage.TYPE_INT_RGB);
            Graphics2D graphics = bufferedImage.createGraphics();
            graphics.drawImage(image,0,0,imageWidth,imageHeight,null);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL,RenderingHints.VALUE_STROKE_NORMALIZE);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING,RenderingHints.VALUE_RENDER_QUALITY);

            //draw text
            for (CertificateVo txtVo : addTexts){
                graphics.setFont(txtVo.getFont());
                graphics.setColor(txtVo.getColor());
                graphics.drawString(txtVo.getText(),txtVo.getX(),txtVo.getY());
            }
            File file = new File(outputImagePath);
            if (!file.getParentFile().exists()){
                FileUtils.forceMkdir(file.getParentFile());
            }
            fileOutput = new FileOutputStream(outputImagePath);
            ImageIO.write(bufferedImage,"jpeg",fileOutput);
            fileOutput.flush();
        }finally {
            if (templateInput != null){
                IOUtils.closeQuietly(templateInput);
            }
            if (fileOutput != null){
                IOUtils.closeQuietly(fileOutput);
            }
        }
    }

    private static InputStream loadTemplateImage(String imageTemplatePath) throws IOException {
        URL url = ResourceUtils.getURL(imageTemplatePath);
        return url.openStream();
    }


//    public static void main(String[] args){
//        try {
//            List<CertificateVo> addTexts = Lists.newArrayList();
//            Calendar now = Calendar.getInstance();
//            addTexts.add(new CertificateVo("刘扬",new Font("微软雅黑",Font.BOLD,50),250,1100));
//            addTexts.add(new CertificateVo(now.get(Calendar.YEAR)+"",new Font("微软雅黑",Font.PLAIN,30),550,1245));
//            addTexts.add(new CertificateVo(now.get(Calendar.MONTH) +1+"",new Font("微软雅黑",Font.PLAIN,30),680,1245));
//            addTexts.add(new CertificateVo(now.get(Calendar.DATE)+"",new Font("微软雅黑",Font.PLAIN,30),790,1245));
//            UserUtils.generateCertificate("classpath:certificate.jpeg","/Users/liuyang/Pictures/certificate.jpeg",addTexts);
//        }catch (IOException e){
//            e.printStackTrace();;
//        }
//
//    }
}
