<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld" %>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld" %>

<head>
	

</head>
		

<div class="main-content">
	<div class="breadcrumbs" id="breadcrumbs">
		

		<ul class="breadcrumb">
			<li>
				<i class="icon-home home-icon"></i>
				<a href="#">首页</a>
			</li>
			<li class="active">彩虹计划</li>
			<li class="active">愿望管理</li>
			
		</ul><!-- .breadcrumb -->

		
	</div>
	<div class="page-content">
		<div class="row">
			<div class="col-xs-12">
			<div class="widget-toolbox">
				<div class="btn-group">
					<%-- <button class="btn btn-sm btn-success" onclick="window.location.href='<webpath:path/>/rainbow/wish/view'">
						<i class="icon-plus bigger-110"></i>
						新增
					</button> --%>
					
					<button class="btn btn-sm btn-success" onclick="wish.batchUpdateStatus()">
						<i class="icon-lightbulb bigger-110"></i>
						修改状态
					</button>
					
					
				</div>
				<div class="pull-right">
					<select class="" id="activity" name="activity">
						<option value="">请选择活动</option>
						<c:forEach var="list" items="${activitylist}">
							<option value="${list.id}" <c:if test="${wishVo.activityId==list.id}">selected</c:if>>${list.name}</option>
						</c:forEach>
					</select>
					<select class="" id="status" name="status">
						<option value="">请选择愿望状态</option>
						<option value="0" <c:if test="${wishVo.status==0}">selected</c:if>>发布</option>
						<option value="1" <c:if test="${wishVo.status==1}">selected</c:if>>认领</option>
						<option value="2" <c:if test="${wishVo.status==2}">selected</c:if>>寄送中</option>
						<option value="3" <c:if test="${wishVo.status==3}">selected</c:if>>红会代收</option>
						<option value="4" <c:if test="${wishVo.status==4}">selected</c:if>>完成</option>
					</select>
					<input type="text" placeholder="查询" class="nav-search-input" id="searchStr" value="${wishVo.searchStr}" autocomplete="off">
					<a href="javascript:void(0);" onclick="wish.search();"><i class="icon-search nav-search-icon"></i></a>
				</div>
			</div>
										
				<div class="pull-left">共${wishPage.recordTotal}条</div>
						<table id="table-data" class="table table-bordered ">
							<thead>
								<tr class="" >
									<th class="center" width="2%">
										<label>
											<input type="checkbox" class="ace">
											<span class="lbl"></span>
										</label>
									</th>
									<th width="70">图片</th>
									<th width="">小朋友</th>
									<th width="10%">愿望</th>
									<th width="20%">内容</th>
									<th width="">爱心人士</th>
									<th width="">寄送方式</th>
									
									<th width="">所属活动</th>
									<th width="">状态</th>
									<th width="5%">发布时间</th>
									<th width="2%">操作</th>
								</tr>
							</thead>
				
							<tbody>
								<c:forEach var="wish" items="${wishPage.records}">
									<tr class="tr-highlight">
										<td class="center" width=10>
											<label>
												<input type="checkbox" name="id" id="id" class="ace" value="${wish.id}">
												<span class="lbl"></span>
											</label>
										</td>
										<td title="" valign="middle"><a href="#"><img alt="" src="<webpath:path/>/wx/rainbowplan/loadResource?imageName=${wish.uploadImage}" width="60" height="60"/></a></td>
										<td title="">姓名：${wish.children.name}&nbsp; 楼层床号：${wish.children.bedNum}<br/>
										收件人：${wish.children.receiveName} &nbsp;联系方式：${wish.children.connectTel}<br/>
										收件地址：${wish.children.receiveAddress};

										</td>
										<td title="" valign="middle">
										编号：${wish.code}<br>
										愿望：${wish.title}</td>
										<td title="" valign="middle"><div class="slim-scroll" style="overflow: hidden; width: auto; height: 65px;">${wish.content}</div></td>
										<td title="" valign="middle">
										<c:if test="${wish.volunteer != null}">姓名：${wish.volunteer.name}<br/>
										手机：${wish.volunteer.phone}<br/>
										回寄地址：${wish.volunteer.receiveAddress}</c:if>
										</td>
										<td title="" valign="middle"><c:if test="${wish.helpType == 1}">自送</c:if>
										<c:if test="${wish.helpType == 2}">快递：${wish.expressCompany}<br>
										单号：${wish.expressCode}</c:if></td>
										
										<td title="" valign="middle">${wish.activity.name}</td>
										<td title="" valign="middle">
										<c:if test="${wish.status == 0}"><span class="label label-warning">发布</span></c:if>
										<c:if test="${wish.status == 1}"><span class="label label-info">认领</span></c:if>
										<c:if test="${wish.status == 2}"><span class="label label-purple">寄送中</span></c:if>
										<c:if test="${wish.status == 3}"><span class="label label-pink">红会代收</span></c:if>
										<c:if test="${wish.status == 4}"><span class="label label-success">完成</span></c:if>
										</td>
										
	
										<td title="" valign="middle"><fmt:formatDate value='${wish.createTime}' pattern='yyyy-MM-dd HH:mm' /></td>
										<td>
											<div class="visible-md visible-lg hidden-sm hidden-xs btn-group">
			
												<button class="btn btn-xs btn-info" onclick="window.location.href='<webpath:path/>/rainbow/wish/view?id=${wish.id}'">
													<i class="icon-edit bigger-120"></i>
												</button>
												&nbsp;
					
												<%-- <a class="btn btn-xs  btn-link" title="详细信息" href="<webpath:path/>/rainbow/wish/view?id=${wish.id}">
													<i class="icon-list-alt bigger-120"></i>
												</a> --%>
					
												
											</div>
					
											
										</td>
									</tr>
								</c:forEach>
							</tbody>
						</table>
					
					
												
					<webpage:page totalCount="${wishPage.recordTotal}"
					pageCount="${pageCount}" currentPage="${pageNumber}"
					action="/rainbow/wish/list"
					className="pageable-div pagination" 
					innerStyle=" float: left; width: 100%" /> 								

				</div>
			
		</div>
	</div>

</div>



<script src="<webpath:path/>/resources/js/rainbow/wish.js?v=window.number" type="text/javascript"></script>