package com.qiankun.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.qiankun.dao.UserDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.User;
import com.qiankun.pages.IPageList;
import com.qiankun.utils.MD5;

@Service
public class UserService {

	@Autowired
	private UserDao userDao;
	
	public User findById(String id) {
		User user = userDao.find(id);
		return user;
	}
	
	
	@Transactional
	public User save(User user) {
		return userDao.save(user);		
	}
	
	@Transactional
	public void remove(String id) {
		userDao.remove(id);
	}
	
	public User userLogin(final String userName, final String password) {
		return userDao.login(userName, MD5.digest(password));
	}

	
	public IPageList<User> findByUsers(String searchStr,String role, String status, String order,String sort, Hints hints){
		IPageList<User> users = userDao.findUserPage(searchStr, role, status, order, sort, hints);
		return users;
	}
	
	public Boolean validateUserExistByPaperId(String paperId) {
		return userDao.validateUserExistByPaperId(paperId);
	}
	
	public Boolean validateUserExistByUserName(String userName) {
		return userDao.validateUserExistByUserName(userName);
	}
	
	
	public Boolean validatePwd(String id, String password) {
		return userDao.validatePwd(id, MD5.digest(password));
	}
	public User findByOpenid(String openid){
	    return userDao.findByOpenid(openid);
    }

    public User findByPaperId(String paperId, String paperType) {
	    return userDao.findByPaperId(paperId,paperType);
    }
}
