package com.qiankun.controller;
 
import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.common.collect.Maps;
import com.qiankun.entity.ActivityReg;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.qiankun.annotation.Auth;
import com.qiankun.controller.base.BaseController;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.Activity;
import com.qiankun.entity.ActivityType;
import com.qiankun.pages.IPageList;
import com.qiankun.service.ActivityService;
import com.qiankun.vo.ActivityVo;
 
@Controller
public class ActivityController extends BaseController<Object>{
 
	@Autowired
	private ActivityService activityService;
	
	@Auth(verifyLogin = false,verifyURL = false)
	@RequestMapping(value = "/wx/api/activity/list", method = RequestMethod.POST)
    public @ResponseBody Map<String, Object> listformWX(@RequestBody ActivityVo activityVo, HttpServletResponse response, HttpServletRequest request) throws Exception {
        IPageList<Activity> userPage = activityService.findByActivitys(activityVo.getSearchStr(), activityVo.getType(), activityVo.getOrder(), activityVo.getSort(), 
					new Hints(getStartRow(request), getPageCount(request)));
        Map<String, Object> map = new HashMap<>();
        map.put("activityData", userPage);
        map.put("pageCount", getPageCount(request));
        map.put("pageNumber", getPageNumber(request));
        map.put("activityVo", activityVo);
        return map;
    }
	
	@Auth(verifyLogin = false,verifyURL = false)
	@RequestMapping(value = "/wx/api/activity", method = RequestMethod.POST)
    public @ResponseBody Map<String,Object> entityformWX(@RequestBody ActivityVo activityVo, HttpServletResponse response, HttpServletRequest request) throws Exception {
        Map<String,Object> result = Maps.newConcurrentMap();
	    Activity activity = activityService.findById(activityVo.getId());
	    result.put("status","ok");
	    result.put("activity",activity);
	    result.put("activityRegCount",activity.getActivityReg().size());
        Iterator<ActivityReg> it = activity.getActivityReg().iterator();
        boolean currentUserApplyed = false;//当前用户是否报名
        while (it.hasNext()){
            ActivityReg reg = it.next();
            if (reg.getUser().getId().equals(activityVo.getUserId())){
                currentUserApplyed = true;
                break;
            }
        }
        result.put("currentUserApplyed",currentUserApplyed);
        return result;
    }
	
	@Auth(verifyLogin = false,verifyURL = false)
	@RequestMapping(value = "/wx/api/activity/type/list", method = RequestMethod.GET)
    public @ResponseBody List<ActivityType> typesformWX(HttpServletResponse response, HttpServletRequest request) throws Exception {  
        return activityService.findActivitysTypes();
    }
	
	
    
    @RequestMapping("/activity/list")
    public ModelAndView list(ActivityVo activityVo, HttpServletResponse response, HttpServletRequest request) throws Exception {
        ModelAndView view = new ModelAndView();
        IPageList<Activity> userPage = activityService.findByActivitys(activityVo.getSearchStr(), activityVo.getType(), activityVo.getOrder(), activityVo.getSort(), 
					new Hints(getStartRow(request), getPageCount(request)));
			
		view.getModelMap().addAttribute("activityPage", userPage);
		view.getModelMap().addAttribute("pageCount", getPageCount(request));
		view.getModelMap().addAttribute("pageNumber", getPageNumber(request));
		view.getModelMap().addAttribute("activityVo", activityVo);
		
		
        view.setViewName("activity/activitylist");
        return view;
    }
    
    
    @RequestMapping("/activity/type/list")
    public ModelAndView typelist(HttpServletResponse response, HttpServletRequest request) throws Exception {
        ModelAndView view = new ModelAndView();			
		view.getModelMap().addAttribute("typelist", activityService.findActivitysTypes());
        view.setViewName("activity/typelist");
        return view;
    }
    
    @RequestMapping("/activity/type/add")
    public ModelAndView typeAdd(String id) throws Exception {
        ModelAndView view = new ModelAndView();  
        Activity activity = new Activity();
        if(StringUtils.isNotBlank(id)) {
        	activity = activityService.findById(id);      
        }
         
        view.setViewName("activity/saveactivity");
        view.getModel().put("activity", activity);
        return view;
    }
    
    @RequestMapping("/activity/add")
    public ModelAndView activityAdd(String id) throws Exception {
        ModelAndView view = new ModelAndView();  
        Activity activity = new Activity();
        if(StringUtils.isNotBlank(id)) {
        	activity = activityService.findById(id);      
        }
         
        view.setViewName("activity/saveactivity");
        view.getModel().put("activity", activity);
        return view;
    }
    
    @RequestMapping("/api/activity/type/save")
	public void saveType(String id, String name, HttpServletResponse response, HttpServletRequest request) throws Exception {
    	ActivityType type =  new  ActivityType();
    	type.setName(name);
    	type.setId(id);
    	activityService.saveType(type);
    }
    
    
    @Auth(verifyLogin = false,verifyURL = false)
    @RequestMapping(value = "/wx/api/activity/save",method = RequestMethod.POST)
    public @ResponseBody Map<String,Object> saveUserFormWX(@RequestBody ActivityVo activityVo, HttpServletResponse response, HttpServletRequest request) throws Exception{
    	return this.save(activityVo, response, request);
    }
    
    
    @RequestMapping("/api/activity/save")
	public Map<String, Object> save(ActivityVo activityVo, HttpServletResponse response, HttpServletRequest request) throws Exception {
	    	
	        Map<String, Object> map = new HashMap<>();
	        Activity activity = new Activity();
	    	if (StringUtils.isEmpty(activityVo.getId())) {
	    		Date date = new Date();	
	    		activity.setCreateTime(date);
	    		map.put("status", 1);
	    	} else {
	    		activity = activityService.findById(activityVo.getId());
	    		map.put("status", 2);
	    	}
	    	
	    	activity.setAddr(activityVo.getAddr());
	    	activity.setAvailable(activityVo.getAvailable());
	    	activity.setContacts(activityVo.getContacts());
	    	activity.setContent(activityVo.getContent());
	    	activity.setCrowd(activityVo.getCrowd());
	    	
	    	SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
	    	activity.setDay(sdf.parse(activityVo.getDay()));
	    	activity.setMax(activityVo.getMax());
	    	activity.setName(activityVo.getName());
	    	activity.setTel(activityVo.getTel());
	    	activity.setType(activityVo.getType());
	    	
	    	Activity a = activityService.save(activity);
	    	
	    	map.put("activity", a);
	    	return map;
	    	
	}

    
    
    
    
    
    
    
    
    
    
    
    
    

}