package com.qiankun.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaKefuMessage;
import cn.binarywang.wx.miniapp.bean.WxMaMessage;
import cn.binarywang.wx.miniapp.bean.WxMaTemplateData;
import cn.binarywang.wx.miniapp.bean.WxMaTemplateMessage;
import cn.binarywang.wx.miniapp.config.WxMaInMemoryConfig;
import cn.binarywang.wx.miniapp.message.WxMaMessageHandler;
import cn.binarywang.wx.miniapp.message.WxMaMessageRouter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.io.File;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author <a href="https://github.com/binarywang">Binary Wang</a>
 */
@Configuration
public class WxMaConfiguration {
    private final  WxMaMessageHandler templateMsgHandler = new WxMaMessageHandler() {
        public void handle(WxMaMessage wxMessage, Map<String, Object> context, WxMaService service, WxSessionManager sessionManager) throws WxErrorException {
            service.getMsgService().sendTemplateMsg(WxMaTemplateMessage.builder()
                    .templateId("此处更换为自己的模板id")
                    .formId("自己替换可用的formid")
                    .data(Lists.newArrayList(
                            new WxMaTemplateData("keyword1", "339208499", "#173177")))
                    .toUser(wxMessage.getFromUser())
                    .build());
        }
    };



    private final WxMaMessageHandler logHandler = new WxMaMessageHandler() {
        public void handle(WxMaMessage wxMessage, Map<String, Object> context, WxMaService service, WxSessionManager sessionManager) throws WxErrorException {
            System.out.println("收到消息：" + wxMessage.toString());
            service.getMsgService().sendKefuMsg(WxMaKefuMessage.newTextBuilder().content("收到信息为：" + wxMessage.toJson())
                    .toUser(wxMessage.getFromUser()).build());
        }
    };

    private final WxMaMessageHandler textHandler = new WxMaMessageHandler() {
        public void handle(WxMaMessage wxMessage, Map<String, Object> context, WxMaService service, WxSessionManager sessionManager) throws WxErrorException {
            service.getMsgService().sendKefuMsg(WxMaKefuMessage.newTextBuilder().content("回复文本消息")
                    .toUser(wxMessage.getFromUser()).build());
        }
    };

    private final WxMaMessageHandler picHandler = new WxMaMessageHandler() {
        public void handle(WxMaMessage wxMessage, Map<String, Object> context, WxMaService service, WxSessionManager sessionManager) throws WxErrorException {
            try {
                WxMediaUploadResult uploadResult = service.getMediaService()
                        .uploadMedia("image", "png",
                                ClassLoader.getSystemResourceAsStream("tmp.png"));
                service.getMsgService().sendKefuMsg(
                        WxMaKefuMessage
                                .newImageBuilder()
                                .mediaId(uploadResult.getMediaId())
                                .toUser(wxMessage.getFromUser())
                                .build());
            } catch (WxErrorException e) {
                e.printStackTrace();
            }
        }
    };

    private final WxMaMessageHandler qrcodeHandler = new WxMaMessageHandler() {
        public void handle(WxMaMessage wxMessage, Map<String, Object> context, WxMaService service, WxSessionManager sessionManager) throws WxErrorException {
            try {
                final File file = service.getQrcodeService().createQrcode("123", 430);
                WxMediaUploadResult uploadResult = service.getMediaService().uploadMedia("image", file);
                service.getMsgService().sendKefuMsg(
                        WxMaKefuMessage
                                .newImageBuilder()
                                .mediaId(uploadResult.getMediaId())
                                .toUser(wxMessage.getFromUser())
                                .build());
            } catch (WxErrorException e) {
                e.printStackTrace();
            }
        }
    };
    @Autowired
    private WxMaProperties properties;

    private static Map<String, WxMaMessageRouter> routers = Maps.newHashMap();
    private static Map<String, WxMaService> maServices = Maps.newHashMap();


//    public WxMaConfiguration(WxMaProperties properties) {
//        this.properties = properties;
//    }

    public static Map<String, WxMaMessageRouter> getRouters() {
        return routers;
    }

    public static WxMaService getMaService(String appid) {
        WxMaService wxService = maServices.get(appid);
        if (wxService == null) {
            throw new IllegalArgumentException(String.format("未找到对应appid=[%s]的配置，请核实！", appid));
        }

        return wxService;
    }
//    public WxMaConfiguration(){
//        this.properties = new WxMaProperties();
//    }
    @Bean
    public Object services() {
        maServices = this.properties.getConfigs()
                .stream()
                .map(a -> {
                    WxMaInMemoryConfig config = new WxMaInMemoryConfig();
                    config.setAppid(a.getAppid());
                    config.setSecret(a.getSecret());
                    config.setToken(a.getToken());
                    config.setAesKey(a.getAesKey());
                    config.setMsgDataFormat(a.getMsgDataFormat());

                    WxMaService service = new WxMaServiceImpl();
                    service.setWxMaConfig(config);
                    routers.put(a.getAppid(), this.newRouter(service));
                    return service;
                }).collect(Collectors.toMap(s -> s.getWxMaConfig().getAppid(), a -> a));

        return Boolean.TRUE;
    }

    private WxMaMessageRouter newRouter(WxMaService service) {
        final WxMaMessageRouter router = new WxMaMessageRouter(service);
        router
            .rule().handler(logHandler).next()
            .rule().async(false).content("模板").handler(templateMsgHandler).end()
            .rule().async(false).content("文本").handler(textHandler).end()
            .rule().async(false).content("图片").handler(picHandler).end()
            .rule().async(false).content("二维码").handler(qrcodeHandler).end();
        return router;
    }

}
