package com.qiankun.controller;
 
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.qiankun.annotation.Auth;
import com.qiankun.controller.base.BaseController;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.Product;
import com.qiankun.entity.User;
import com.qiankun.pages.IPageList;
import com.qiankun.service.UserService;
import com.qiankun.utils.MD5;
import com.qiankun.utils.SessionUtils;
import com.qiankun.vo.ProductVo;
import com.qiankun.vo.UserVo;
 
@Controller
public class UserController extends BaseController<Object>{
    
    @Autowired
	private UserService userService;
    
    @Auth(verifyLogin = false, verifyURL = false)
    @RequestMapping("/reg")
    public ModelAndView index() throws Exception {
        ModelAndView t_view = new ModelAndView();
        t_view.setViewName("reg");
        return t_view;
    }
    
    @Auth(verifyLogin = false, verifyURL = false)
    @RequestMapping("/")
    public ModelAndView login() throws Exception {
        ModelAndView t_view = new ModelAndView();
        t_view.setViewName("index");
        return t_view;
    }
    
    @Auth(verifyLogin = false, verifyURL = false)
    @RequestMapping("/match")
    public ModelAndView match() throws Exception {
        ModelAndView t_view = new ModelAndView();
        t_view.setViewName("match");
        return t_view;
    }
    

    @Auth(verifyLogin = false, verifyURL = false)
    @RequestMapping("/api/user/save")
    public ModelAndView saveUser(UserVo userVo, HttpServletResponse response, HttpServletRequest request) throws Exception {
    	
        ModelAndView view = new ModelAndView();

        User user = new User();
       
        if (StringUtils.isEmpty(userVo.getId())) {
        	
        	Boolean userIsExistMobile = userService.validateUserExistByMobile(userVo.getMobile());
        	if (userIsExistMobile) {
				view.getModel().put("message", "userIsExist_mobile");
				return view;
			}
        	
			Boolean userIsExistUserName = userService.validateUserExistByTeamName(userVo.getTeamName());
			if (userIsExistUserName) {
				view.getModel().put("message", "userIsExist_teamName");
				return view;
			}
        	     	
        	user.setContacts(userVo.getContacts());
        	user.setGroups(userVo.getGroups());
        	user.setMobile(userVo.getMobile());
        	user.setPwd(MD5.digest(userVo.getPwd()));
        	user.setUserName(userVo.getUserName());
        	user.setTeamName(userVo.getTeamName());
        	user.setEmail(userVo.getEmail());
        	Date date = new Date();
        	user.setCreateTime(date);
        	
        	SimpleDateFormat sdf = new SimpleDateFormat("yyyy");        
        	String year = sdf.format(date);
        	
        	Long code = null;
        	User last = userService.findLastUserByGroup(userVo.getGroups());
        	if (last != null) {
        		code = Long.valueOf(last.getUserId().substring(6))+1;
        	} else {
        		code = Long.valueOf(userVo.getGroups() + "000001");
        	}

        	String userId = "IE" + year + code;
        	user.setUserId(userId);
        	
        	Product product = new Product();
        	product.setUser(user);
        	product.setCreateTime(date);
        	user.getProduct().add(product);
        	view.getModelMap().put("status", 1);
        	       	
        } else {
        	if(userVo.getChangePassword()!=null&&userVo.getChangePassword()){
        		Boolean validatePwd = userService.validatePwd(userVo.getId(), userVo.getOldpwd());
        		if (!validatePwd) {
        			view.getModel().put("message", "oldPwdError");
    				return view;
        		}
			}
        	user = userService.findById(userVo.getId());     
        	if (StringUtils.isNotBlank(userVo.getTeamName()) && !userVo.getTeamName().equals(user.getTeamName())) {
        		Boolean userIsExistUserName = userService.validateUserExistByTeamName(userVo.getTeamName());
    			if (userIsExistUserName) {
    				view.getModel().put("message", "userIsExist_teamName");
    				return view;
    			}
        	}
        	
        	if(userVo.getChangePassword()!=null && userVo.getChangePassword()){
        		user.setPwd(MD5.digest(userVo.getPwd()));		
        	}
        	user.setUserName(userVo.getUserName());
        	user.setTeamName(userVo.getTeamName());
        	user.setEmail(userVo.getEmail());
        	user.setContacts(userVo.getContacts());
        	user.setTeacher(userVo.getTeacher());
        	user.setTeacherEmail(userVo.getTeacherEmail());
        	user.setTeacherTel(userVo.getTeacherTel());
        	
        	user.setMemberName1(userVo.getMemberName1());
        	user.setMemberEmail1(userVo.getMemberEmail1());
        	user.setMemberTel1(userVo.getMemberTel1());
        	user.setMemberGender1(userVo.getMemberGender1());
        	user.setMemberGrade1(userVo.getMemberGrade1());
        	
        	user.setMemberName2(userVo.getMemberName2());
        	user.setMemberEmail2(userVo.getMemberEmail2());
        	user.setMemberTel2(userVo.getMemberTel2());
        	user.setMemberGender2(userVo.getMemberGender2());
        	user.setMemberGrade2(userVo.getMemberGrade2());
        	
        	user.setMemberName3(userVo.getMemberName3());
        	user.setMemberEmail3(userVo.getMemberEmail3());
        	user.setMemberTel3(userVo.getMemberTel3());
        	user.setMemberGender3(userVo.getMemberGender3());
        	user.setMemberGrade3(userVo.getMemberGrade3());
        	
        	user.setMemberName4(userVo.getMemberName4());
        	user.setMemberEmail4(userVo.getMemberEmail4());
        	user.setMemberTel4(userVo.getMemberTel4());
        	user.setMemberGender4(userVo.getMemberGender4());
        	user.setMemberGrade4(userVo.getMemberGrade4());
        	
        }      
        userService.save(user);
        return view;
    }
    
    @Auth(verifyLogin = false, verifyURL = false)
	@RequestMapping("/api/signin")
	public ModelAndView signin(HttpServletRequest request,
			final HttpServletResponse response, String mobile, String pwd)
			throws Exception {
		ModelAndView view = new ModelAndView();
		ResourceBundle rb = ResourceBundle.getBundle("system");
		String superAdmin = rb.getString("account");
		
		if (mobile.equals(superAdmin)) {
			
	        String p = rb.getString("password");
	        if (p.equals(pwd)) {
	        	User user = new User();
	        	user.setMobile(superAdmin);
	        	user.setUserName(superAdmin);
	        	user.setPwd(MD5.digest(pwd));
	        	SessionUtils.setUser(request, user);		
	        	view.getModelMap().addAttribute("status", 2);
	        } else {
	        	view.getModelMap().addAttribute("status", 0);
	        }
	        
	        		
	        		
		} else {
			User user = userService.userLogin(mobile, pwd);
			if (user != null) {
				// 设置User到Session
	 			SessionUtils.setUser(request, user);		
	 			view.getModelMap().addAttribute("status", 1);
			} else {
				view.getModelMap().addAttribute("status", 0);			
			}
		}
		
		
		return view;
	}
    
    @RequestMapping("/api/user/list")
    public ModelAndView userList(UserVo userVo, HttpServletResponse response, HttpServletRequest request) throws Exception {
        ModelAndView view = new ModelAndView();
        ResourceBundle rb = ResourceBundle.getBundle("system");
		String superAdmin = rb.getString("account");
		String p = rb.getString("password");
		User userSession = SessionUtils.getUser(request);
		
		
		if (superAdmin.equals(userSession.getMobile()) && MD5.digest(p).equals(userSession.getPwd())) {
			
			IPageList<User> userPage = userService.findByUsers(userVo.getSearchStr(), userVo.getGroups(), userVo.getOrder(), userVo.getSort(), 
					new Hints(getStartRow(request), getPageCount(request)));
			
			view.getModelMap().addAttribute("userPage", userPage);
			view.getModelMap().addAttribute("pageCount", getPageCount(request));
			view.getModelMap().addAttribute("pageNumber", getPageNumber(request));
			view.getModelMap().addAttribute("userVo", userVo);
			view.setViewName("userList");
		} else {
			SessionUtils.removeUser(request);
			view.setViewName("index");
		}
        
        
        return view;
    }
    
    @RequestMapping("/api/user/del")
    public ModelAndView delUser(String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
    	ModelAndView view = new ModelAndView();
    	User userSession = SessionUtils.getUser(request);
    	ResourceBundle rb = ResourceBundle.getBundle("system");
 		String superAdmin = rb.getString("account");
    	if (superAdmin.equals(userSession.getMobile()) && (superAdmin.equals(userSession.getUserName()))) {
    		userService.remove(id);     		
    	} else {
    		view.getModelMap().addAttribute("userPage", "Illegal Users");
    	}
    	return view;
    }
    
    @RequestMapping("/api/product/save")
    public ModelAndView saveProduct(ProductVo productVo, HttpServletResponse response, HttpServletRequest request) throws Exception {
    	ModelAndView view = new ModelAndView();
    	User userSession = SessionUtils.getUser(request);
    	User user = userService.findById(userSession.getId());
		Product product = new Product();
		Set<Product> productSet = user.getProduct();
		Iterator<Product> its = productSet.iterator();
		if (its.hasNext()) {
			product = its.next();
		}
		product.setName(productVo.getName());
		product.setContent1(productVo.getContent1());
		product.setContent2(productVo.getContent2());
		product.setContent3(productVo.getContent3());
		product.setUpdateTime(new Date());
		user.getProduct().clear();
		user.getProduct().add(product);
		userService.save(user);
		view.getModelMap().put("message","success");
    	return view;
    }
    
    @RequestMapping("/profile")
    public ModelAndView profile(HttpServletResponse response, HttpServletRequest request) throws Exception {
		ModelAndView view = new ModelAndView();
		User user = SessionUtils.getUser(request);
		view.getModelMap().put("user",userService.findById(user.getId()));
		view.setViewName("profile");
		return view;
	}

    @RequestMapping("/product")
    public ModelAndView product(HttpServletResponse response, HttpServletRequest request) throws Exception {
		ModelAndView view = new ModelAndView();
		User userSession = SessionUtils.getUser(request);
		User user = userService.findById(userSession.getId());
		Product product = new Product();
		Set<Product> productSet = user.getProduct();
		Iterator<Product> its = productSet.iterator();
		if (its.hasNext()) {
			product = its.next();
		}
		
		view.getModelMap().put("product",product);
		view.getModelMap().put("user",user);
		
		view.setViewName("product");
		return view;
	}
    @RequestMapping("/api/product/enroll/upload")
    public ModelAndView uploadEnroll(@RequestParam(value = "enroll", required = false) MultipartFile file, HttpServletResponse response,
			HttpServletRequest request) throws Exception {
    	ModelAndView view = this.writeImportFile(file , "enroll", new ModelAndView(), request);
    	return view; 	
    }
    
    @RequestMapping("/api/product/report/upload")
    public ModelAndView uploadReport(@RequestParam(value = "report", required = false) MultipartFile file, HttpServletResponse response,
			HttpServletRequest request) throws Exception {
    	ModelAndView view = this.writeImportFile(file , "report", new ModelAndView(), request);
    	return view; 	
    }
    
    @RequestMapping("/api/product/ppt/upload")
    public ModelAndView uploadPPT(@RequestParam(value = "ppt", required = false) MultipartFile file, HttpServletResponse response,
			HttpServletRequest request) throws Exception {
    	ModelAndView view = this.writeImportFile(file , "ppt", new ModelAndView(), request);
    	return view; 	
    }
    
    @RequestMapping("/api/product/attachment/upload")
    public ModelAndView uploadAttachment(@RequestParam(value = "attachment", required = false) MultipartFile file, HttpServletResponse response,
			HttpServletRequest request) throws Exception {
    	ModelAndView view = this.writeImportFile(file , "attachment", new ModelAndView(), request);
    	return view; 	
    }
    
    public ModelAndView writeImportFile(MultipartFile file, String type, ModelAndView view, HttpServletRequest request) throws Exception {
    	if (file != null) {			
			if (file.getSize()<=0) {
				view.getModelMap().put("status", 0);
	    		view.getModelMap().put("size", 0);
	    		return view;
	    	}
			if ("enroll".equals(type) && file.getSize() > 10240000) {
				view.getModelMap().put("size", 10);
				view.getModelMap().put("status", 0);
				return view;
			}
			if ("report".equals(type) && file.getSize() > 51200000) {
				view.getModelMap().put("size", 50);
				view.getModelMap().put("status", 0);
				return view;
			}
			if ("ppt".equals(type) && file.getSize() > 102400000) {
				view.getModelMap().put("size", 100);
				view.getModelMap().put("status", 0);
				return view;
			}
			if ("attachment".equals(type) && file.getSize() > 102400000) {
				view.getModelMap().put("size", 100);
				view.getModelMap().put("status", 0);
				return view;
			}
		}
    	
    	User userSession = SessionUtils.getUser(request);
    	
        ResourceBundle rb = ResourceBundle.getBundle("system");
        String path = rb.getString("file_path") + userSession.getUserId() + "/";
        File f = new File(path);
        if (!f.exists() && !f.isDirectory()) {
        	f.mkdir();
        }
        
        path = path + type + "/";
        f = new File(path);

        if (!f.exists() && !f.isDirectory()) {
        	f.mkdir();
	    }
        
        if (f.exists() && f.isDirectory()) {

        	String[] tempList = f.list();  
            File temp = null;  
            for (int i = 0; i < tempList.length; i++) {  
                if (path.endsWith(File.separator)) {  
                    temp = new File(path + tempList[i]);  
                } else {  
                    temp = new File(path + File.separator + tempList[i]);  
                }  
                if (temp.isFile()) {  
                    temp.delete();  
                }  
               
            }  
            
	    }
        
 
        String fileFullName = file.getOriginalFilename();
        FileOutputStream t_fos = null;
        try {
            t_fos = new FileOutputStream(new File(path, fileFullName), true);
            t_fos.write(file.getBytes());
        } finally {
            try {
                if (t_fos != null) {
                    t_fos.flush();
                    t_fos.close();
                }
            } catch (final Exception t_e) {
                throw t_e;
            }
        }
        view.getModelMap().put("fileName", fileFullName);
        view.getModelMap().put("status", 1);
        
        
        User user = userService.findById(userSession.getId());
		Product product = new Product();
		Set<Product> productSet = user.getProduct();
		Iterator<Product> its = productSet.iterator();
		if (its.hasNext()) {
			product = its.next();
		}
		if ("enroll".equals(type)) {
			product.setEnroll(fileFullName);
		}
		if ("report".equals(type)) {
			product.setReport(fileFullName);
		}
		if ("ppt".equals(type)) {
			product.setPpt(fileFullName);
		}
		if ("attachment".equals(type)) {
			product.setAttachment(fileFullName);
		}
		product.setUpdateTime(new Date());
		user.getProduct().clear();
		user.getProduct().add(product);
		userService.save(user);
		
        return view;
    }
    
    @RequestMapping("/api/product/download")
    public ModelAndView downloadFile(String fileName, String type, String userId, HttpServletRequest request, HttpServletResponse response) throws Exception {
    	ModelAndView view = new ModelAndView();

    	FileInputStream fis = null;
    	OutputStream os = null;
        try {  
        	User userSession = SessionUtils.getUser(request);
        	ResourceBundle rb = ResourceBundle.getBundle("system");
        	if (StringUtils.isBlank(userId)) {
        		userId = userSession.getUserId();
        	}
        	
        	String path = rb.getString("file_path") + userId + "/" + type + "/" + fileName;
        	response.setContentType("application/octet-stream");  
        	response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName,"UTF-8"));
        	//File file = new File(path);  
        	fis = new FileInputStream(path);
            os = response.getOutputStream();
            byte[] b = new byte[1024];
			int i = 0; 
			while ( (i = fis.read(b)) > 0 ) 
			{
			os.write(b, 0, i);
			} 
			os.flush();
            
        } catch (IOException e) {  
            ;
        }  finally {
	        if(fis != null) {  
	        	try{
	            fis.close();
	            fis = null;
	        	}
	            catch(Exception e)
	        	{
	        		//System.out.print(e.toString());
	        	}
	        }
	        if(os != null) {
	         try{
	            os.close();
	            os = null;
	        }
            catch(Exception e)
        	{
        		//System.out.print(e.toString());
        	}
	        }
	    } 
        view.setViewName("download");
    	return view;
    }
}