<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld"%>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld"%>

<head>
	

</head>
		

<div class="main-content">
	<div class="breadcrumbs" id="breadcrumbs">
		

		<ul class="breadcrumb">
			<li>
				<i class="icon-home home-icon"></i>
				<a href="#">首页</a>
			</li>
			<li class="active">活动管理</li>
			<li class="active">${activity.name}</li>
		</ul><!-- .breadcrumb -->

		
	</div>
	<div class="page-content">
		<div class="row">
		
			<div class="col-xs-12">
			<div class="widget-toolbox">
				<div class="btn-group">
					<!--<button class="btn btn-sm btn-success" onclick="window.location.href='<webpath:path/>/activity/add'">
						<i class="icon-plus-sign-alt bigger-110"></i>
						新增
					</button>-->
					
					<button class="btn btn-sm btn-success" onclick="reg.remove('${ActivityRegVo.activityId}','activityId')">
						<i class="icon-trash bigger-110"></i>
						全部清除
					</button>
		
					
				</div>
				
				<div class="pull-right ">
					<input type="hidden" class="nav-search-input" id="activityId" value="${ActivityRegVo.activityId}" autocomplete="off">
					<input type="text" placeholder="查询" class="nav-search-input" id="searchStr" value="${ActivityRegVo.searchStr}" autocomplete="off">
					<a href="javascript:void(0);" id="searchBtn"><i class="icon-search nav-search-icon"></i></a>
				</div>
			</div>
			
			<div class="pull-left">共${regPage.recordTotal}条</div>
				<table id="table-data" class="table table-bordered ">
					<thead>
						<tr class="">
							<!-- <th class="center">
								<label>
									<input type="checkbox" class="ace">
									<span class="lbl"></span>
								</label>
							</th> -->
							<th width="15%">姓名</th>
							<th width="15%">联系电话</th>
							<th width="15%">证件号</th>
							<th width="10%">是否签到</th>
							<th width="15%">签到时间</th>
							<th width="15%">签出时间</th>
							<th width="15%">报名时间</th>
		
							<th width="100">操作</th>
						</tr>
					</thead>
		
					<tbody>
					
						<c:forEach var="reg" items="${regPage.records}">
						<tr class="tr-highlight">
							<!-- <td class="center" width=10>
								<label>
									<input type="checkbox" class="ace">
									<span class="lbl"></span>
								</label>
							</td> -->
		
							<td title="">${reg.user.name}</td>
							<td title="">${reg.user.mobile}</td>
							<td title="">${reg.user.paperId}</td>
							<td title=""><c:if test="${reg.signin}"><span class="label label-success">是</span></c:if><c:if test="${!reg.signin}"><span class="label label-warning">否</span></c:if></td>
							<td title=""><fmt:formatDate value='${reg.signinTime}' pattern='yyyy-MM-dd HH:mm:ss' /></td>
							<td title=""><fmt:formatDate value='${reg.signoutTime}' pattern='yyyy-MM-dd HH:mm:ss'/></td>
							<td title=""><fmt:formatDate value='${reg.createTime}' pattern='yyyy-MM-dd HH:mm:ss' /></td>
							
							<td>
								<div class="visible-md visible-lg hidden-sm hidden-xs btn-group">

									<button class="btn btn-xs btn-danger " onclick="reg.remove('${reg.id}','id')">
										<i class="icon-trash"></i>
									</button>

								</div>
		
								
							</td>
						</tr>
						
						</c:forEach>
		
						
		
						
		
						
					</tbody>
				</table>
											
						<webpage:page totalCount="${regPage.recordTotal}"
												pageCount="${pageCount}" currentPage="${pageNumber}"
												action="/activity/reg/list"
												className="pageable-div pagination" 
												innerStyle=" float: left; width: 100%" /> 								
											
					
			</div>
			
		</div>
	</div>
	
	
	
	
	
	
</div>

<script src="<webpath:path/>/resources/js/activity/activityreg.js" type="text/javascript"></script>