package com.qiankun.controller;
 
import java.io.File;
import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.qiankun.annotation.Auth;
import com.qiankun.controller.base.BaseController;
import com.qiankun.entity.Certificate;
import com.qiankun.service.CertificateService;
 
@Controller
public class CertificateController extends BaseController<Object>{
 
	@Autowired
	private CertificateService certificateService;
	
	private ResourceBundle rb = ResourceBundle.getBundle("system");
	private String certificateImagePath = File.separator + rb.getString("certificateImage");
	private String rootPath = rb.getString("file_path");
    
    @RequestMapping("/certificate/list")
    public ModelAndView list(HttpServletResponse response, HttpServletRequest request) throws Exception {
        ModelAndView view = new ModelAndView();			
		view.getModelMap().addAttribute("list", certificateService.findByAll());
        view.setViewName("certificate/list");
        return view;
    }
    
    @RequestMapping("/certificate/add")
    public ModelAndView add(String id) throws Exception {
        ModelAndView view = new ModelAndView();  
        Certificate certificate = new Certificate();
        if(StringUtils.isNotBlank(id)) {
        	certificate = certificateService.findById(id);      
        }
        view.setViewName("certificate/save");
        view.getModel().put("certificate", certificate);
        return view;
    }
    
    @RequestMapping(value = "/api/certificate/save", method = RequestMethod.POST)
	public ModelAndView save(@RequestParam(value = "file", required = false) MultipartFile file, Certificate certificate, HttpServletResponse response, HttpServletRequest request) throws Exception {
    	
    	ModelAndView view = new ModelAndView();  
    	if (StringUtils.isEmpty(certificate.getId())) {
    		view.getModel().put("status", 1);
    	} else {
    		String id = certificate.getId();
    		String name = certificate.getName();
    		String position = certificate.getPosition();
    		String uploadImage = certificate.getUploadImage();
    		Boolean status = certificate.getStatus();

    		certificate = certificateService.findById(id); 

    		certificate.setName(name);
    		certificate.setPosition(position);
    		certificate.setUploadImage(uploadImage);
    		certificate.setStatus(status);
    		
    		view.getModel().put("status", 2);
    	}
    	
    	if (file != null) {
        	String fileFullName = file.getOriginalFilename();
        	String[] originalFileName = fileFullName.split("\\.");
        	String fileName = System.currentTimeMillis() + "." + originalFileName[originalFileName.length-1];
            
            if (StringUtils.isNotBlank(certificate.getUploadImage())) {
            	File oldFile =  new File(rootPath + certificate.getUploadImage());
            	if (oldFile.isFile())
            		FileUtils.forceDelete(oldFile);
            }
            
            File destFile = new File(rootPath + certificateImagePath,fileName);
            FileUtils.writeByteArrayToFile(destFile,file.getBytes());
            certificate.setUploadImage(certificateImagePath + File.separator + fileName);
        }
    	
    	if (certificate.getStatus()) {
			certificateService.updateStatus(certificate.getId());
		}
    	Certificate entity = certificateService.save(certificate);
    	view.getModel().put("entity", entity);
    	return view;
    }

    @RequestMapping("/api/certificate/del")    
    public ModelAndView delActivityReg(String id,  HttpServletResponse response, HttpServletRequest request) throws Exception {
    	ModelAndView view = new ModelAndView();
    	Certificate certificate = certificateService.findById(id); 
    	if (StringUtils.isNotBlank(certificate.getUploadImage())) {
        	File oldFile =  new File(rootPath + certificate.getUploadImage());
        	if (oldFile.isFile())
        		FileUtils.forceDelete(oldFile);
        }
    	
    	certificateService.remove(id);       	
    	return view;
    }

    
    @Auth(verifyURL = false,verifyLogin = false)
    @RequestMapping(value = "/certificate/template",method = RequestMethod.GET)
    public @ResponseBody Certificate getTemplate(){
                
        return certificateService.findByStatus();
    
    }
}