package com.qiankun.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.qiankun.dao.UserDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.User;
import com.qiankun.pages.IPageList;
import com.qiankun.utils.MD5;

@Service
public class UserService {

	@Autowired
	private UserDao userDao;
	
	public User findById(String id) {
		User user = userDao.find(id);
		return user;
	}
	
	
	@Transactional
	public void save(User user) {
		userDao.save(user);		
	}
	
	@Transactional
	public void remove(String id) {
		userDao.remove(id);
	}
	
	public User userLogin(final String mobile, final String password) {
		return userDao.login(mobile, MD5.digest(password));
	}

	
	public IPageList<User> findByUsers(String searchStr,String groupId,String order,String sort, Hints hints){
		IPageList<User> users = userDao.findUserPage(searchStr, groupId, order, sort, hints);
		return users;
	}
	
	public User findLastUserByGroup(String groupId) {
		return userDao.findLastUserByGroup(groupId);	
	}
	
	public Boolean validateUserExistByMobile(String mobile) {
		return userDao.validateUserExistByMobile(mobile);
	}
	
	public Boolean validateUserExistByTeamName(String userName) {
		return userDao.validateUserExistByTeamName(userName);
	}
	
	
	public Boolean validatePwd(String id, String password) {
		return userDao.validatePwd(id, MD5.digest(password));
	}
}
