package com.qiankun.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.qiankun.dao.ActivityDao;
import com.qiankun.dao.ActivityTypeDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.Activity;
import com.qiankun.entity.ActivityType;
import com.qiankun.pages.IPageList;

@Service
public class ActivityService {

	@Autowired
	private ActivityDao activityDao;
	
	@Autowired
	private ActivityTypeDao activityTypeDao;
	
	public Activity findById(String id) {
		Activity activity = activityDao.find(id);
		return activity;
	}
	
	
	@Transactional
	public Activity save(Activity activity) {
		return activityDao.save(activity);		
	}
	
	@Transactional
	public void remove(String id) {
		activityDao.remove(id);
	}

	public IPageList<Activity> findByActivitys(String searchStr,String type,String order,String sort, Hints hints){
		IPageList<Activity> activitys = activityDao.findActivityPage(searchStr, type, order, sort, hints);
		return activitys;
	}

	
	
	@Transactional
	public ActivityType saveType(ActivityType type) {
		return activityTypeDao.save(type);		
	}
	
	@Transactional
	public void removeType(String id) {
		activityTypeDao.remove(id);
	}
	
	public List<ActivityType> findActivitysTypes(){
		return activityTypeDao.findAll();
	}
	
	public ActivityType findTypeById(String id) {
		ActivityType type = activityTypeDao.find(id);
		return type;
	}
	
	
}
