﻿<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld"%>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld"%>


<head>
	<style type="text/css">
     	body{
			background:url(<webpath:path/>/resources/images/timg1.jpg);
			filter:"progid:DXImageTransform.Microsoft.AlphaImageLoader(sizingMethod='scale')";  
			-moz-background-size:100% 100%;  
			background-size:100% 100%;  
			background-attachment: fixed;
		}
		.h22 {
			FONT-SIZE: 30px; font-family:PingFangSC,helvetica neue,hiragino sans gb,arial,microsoft yahei ui,microsoft yahei,simsun,"sans-serif" !important;font-weight: bold; COLOR: #f0f0f0; FONT-WEIGHT: 5px;
		}
		.divTityle{
			border-bottom: 1px solid rgba(255,255,255,0.3);	
		}
		.form-control{
			height:26px;
		}
		label.error{
			color:#ff0000;
		}
		label.block{
			margin-bottom:10px;
		}
		.a-upload {
		    padding: 6px 10px;
		    height: 25px;
		    line-height: 10px;
		    position: relative;
		    cursor: pointer;
		    color: #888;
		    background: #fafafa;
		    border: 1px solid #ddd;
		    border-radius: 4px;
		    overflow: hidden;
		    display: inline-block;
		    *display: inline;
		    *zoom: 1;
		    float: left;
		}
		
		.a-upload  input {
		    position: absolute;
		    font-size: 100px;
		    right: 0;
		    top: 0;
		    opacity: 0;
		    filter: alpha(opacity=0);
		    cursor: pointer;
		    height: 20px;
		    width: 75px;
		}
		
		.a-upload:hover {
		    color: #444;
		    background: #eee;
		    border-color: #ccc;
		    text-decoration: none
		}
		
		.upload-div {
			height:35px;
			line-height: 23px;
			font-size: 14px;
		}
		.download-a {
		
			margin-left:15px;
			float: left;
		}
		
		#thead th,#thead td, #table-2 tr, #table-2 td{
			padding-top:10px;
			padding-bottom: 10px;

		}
		#table-2 tr {
			border-bottom: 1px solid #bbc3d2bf;
		}
		
		.td-first10{
			padding-left:10px;
		}
		
		
		#table-2 tr:not(:first-child):focust-whithin{
        	background: rgba(173, 216, 230, 0.4);
	    }
	    #table-2 tr:not(:first-child):hover{
	        background: rgba(173, 216, 230, 1);
	    }

	</style>

</head>
	
	<div class="main-container col-sm-12" style="padding:0px; margin:0px;">
			<div class="main-content col-sm-12"  style="padding:0px; margin:0px;">
				<div class="row" style="width:100%;margin:0;">
					<div class="col-sm-12" style="padding:0px; margin:0px;">
						<div class="login-container divTityle" style="width:100%; height:80px;">
							<div class="left col-sm-12 " style="height:0; padding:20px;padding-left:60px;"  >
                            	<img alt="logo" src="<webpath:path/>/resources/images/logo.png" height="40" style=""/>&nbsp;&nbsp;&nbsp;
                                <img alt="wz" src="<webpath:path/>/resources/images/wz.png"  height="40" style="margin-top:5px; "/>&nbsp;&nbsp;&nbsp;
							</div>
		
							<div class="space-6"></div>
							<div class="position-relative" style="top:100px" >
								<div id="login-box" class="login-box visible widget-box no-border " style="width: 96%; margin-left: auto;margin-right: auto; padding: 0px;" >
									<div class="widget-body">
										<div class="widget-main" style="padding: 20px;padding-bottom: 100px;">
											<div class="pull-left">共${userPage.recordTotal}条</div>
											<select id="groups" class="pull-right" name="groups"  onchange="search(this)">
                                               	<option value="">全部分组</option> 
                                               	<option value='1' <c:if test="${userVo.groups==1}">selected="selected"</c:if>>本科生组</option>
												<option value='2' <c:if test="${userVo.groups==2}">selected="selected"</c:if>>研究生组</option>
												<option value='3' <c:if test="${userVo.groups==3}">selected="selected"</c:if>>业界组</option>                                       
											</select>      
											
											
											
											<table class="" id="table-2" style="width:100%">
												<tr id="thead" style=" background-color:rgb(67, 142, 185);" >
													<th width="6%" style=" color:#FFFFFF" class="td-first10">编号</th>
													<th width="6%" style=" color:#FFFFFF" class="td-first10">分组</th>
													<th width="19%" style=" color:#FFFFFF" >单位名称</th>
													<th width="10%" style=" color:#FFFFFF" >团队名称</th>
													<th width="7%" style=" color:#FFFFFF">指导老师</th>
													<th width="7%" style=" color:#FFFFFF">联系人</th>
													<th width="7%" style=" color:#FFFFFF">联系电话</th>
													<th width="10%" style=" color:#FFFFFF">邮箱</th>
													<th width="7%" style=" color:#FFFFFF">注册时间</th>
													<th width="4%" style=" color:#FFFFFF">报名表</th>
													<th width="4%" style=" color:#FFFFFF">报告</th>
													<th width="4%" style=" color:#FFFFFF">PPT</th>
													<th width="4%" style=" color:#FFFFFF">附件</th>
													<th width="4%" style=" color:#FFFFFF">操作</th>
												</tr>
												<c:forEach var="user" items="${userPage.records}">
													<tr class="highlight">
													<td class="td-first10" title="${user.userId}">${user.userId} </td>
													<td class="td-first10" title="
													<c:if test="${user.groups==1}">
						                            	本科生组
						                            </c:if>
						                            <c:if test="${user.groups==2}">
						                            	研究生组
						                            </c:if>
						                            <c:if test="${user.groups==3}">
						                            	业界组
						                            </c:if>
													">
													<c:if test="${user.groups==1}">
						                            	本科生组
						                            </c:if>
						                            <c:if test="${user.groups==2}">
						                            	研究生组
						                            </c:if>
						                            <c:if test="${user.groups==3}">
						                            	业界组
						                            </c:if>
													</td>
													<td title="${user.userName}">${user.userName} </td>
													<td title="${user.teamName}">${user.teamName} </td>
													<td title="${user.teacher}">${user.teacher}</td>
													<td title="${user.contacts}">${user.contacts}</td>
													<td title="${user.mobile}">${user.mobile}</td>
													<td title="${user.email}">${user.email}</td>
													<td title="<fmt:formatDate value='${user.createTime}' pattern='yyyy-MM-dd HH:mm' />"><fmt:formatDate value='${user.createTime}' pattern='yyyy-MM-dd HH:mm' /></td>
													<td title="">
													<c:if test="${user.product.iterator().next().getEnroll()!=null && user.product.iterator().next().getEnroll()!=''}">
													<a href="<webpath:path/>/api/product/download?userId=${user.userId}&type=enroll&fileName=${user.product.iterator().next().getEnroll()}" target="_blank" id="enrollName" class="download-a">下载</a>
													</c:if>
													<c:if test="${user.product.iterator().next().getEnroll()==null || user.product.iterator().next().getEnroll()==''}">
														未上传
													</c:if>
													</td>
													<td title="">
													<c:if test="${user.product.iterator().next().getReport()!=null && user.product.iterator().next().getReport()!=''}">
													<a href="<webpath:path/>/api/product/download?userId=${user.userId}&type=report&fileName=${user.product.iterator().next().getReport()}" target="_blank" id="reportName" class="download-a">下载</a>
													</c:if>
													<c:if test="${user.product.iterator().next().getReport()==null || user.product.iterator().next().getReport()==''}">
														未上传
													</c:if>
													</td>
													<td title="">
													<c:if test="${user.product.iterator().next().getPpt()!=null && user.product.iterator().next().getPpt()!=''}">
													<a href="<webpath:path/>/api/product/download?userId=${user.userId}&type=ppt&fileName=${user.product.iterator().next().getPpt()}" target="_blank" id="pptName" class="download-a">下载</a>
													</c:if>
													<c:if test="${user.product.iterator().next().getPpt()==null || user.product.iterator().next().getPpt()==''}">
														未上传
													</c:if>
													</td>
													<td title="">
													<c:if test="${user.product.iterator().next().getAttachment()!=null && user.product.iterator().next().getAttachment()!=''}">
													<a href="<webpath:path/>/api/product/download?userId=${user.userId}&type=attachment&fileName=${user.product.iterator().next().getAttachment()}" target="_blank" id="attachmentName" class="download-a">下载</a>
													</c:if>
													<c:if test="${user.product.iterator().next().getAttachment()==null || user.product.iterator().next().getAttachment()==''}">
														未上传
													</c:if>
													</td>
													<td title="删除"><a href="javascript:;" onclick="del('${user.id}')">删除</a></td>
													</tr>
												</c:forEach>
											</table>
											
											<webpage:page totalCount="${userPage.recordTotal}"
												pageCount="${pageCount}" currentPage="${pageNumber}"
												action="/api/user/list"
												className="pageable-div pagination" 
												innerStyle=" float: left; width: 100%" /> 
											
										</div><!-- /widget-main -->
									</div><!-- /widget-body -->
								</div><!-- /login-box -->
							</div><!-- /position-relative -->
						</div>
					</div><!-- /.col -->		
				</div><!-- /.row -->
			</div>
		</div>	
	

	<script type="text/javascript">
			if("ontouchend" in document)
				document.write("<script src='resources/assets/js/jquery.mobile.custom.min.js'>"+"<"+"/script>");
		</script>
	
		<script type="text/javascript">
			function del(id){
				var url = window.location.href;
				bootbox.confirm({
					buttons: {
						cancel: {
							label: '取消',
							className: 'btn-default'
						},
						confirm: {
							label: '确认',
							className: 'btn-myStyle'
						}
						
					},
					message: '请确认是否删除?',
					callback: function(result) {
						if(result) {
							$.ajax({
								  type: 'GET',
								  url: '/api/user/del?id='+id,
								  dataType:'json',
								  success: function(data){
									  window.location.href = url;
								  }
							})
						} else {
							
						}
					},
					//title: "bootbox confirm也可以添加标题哦",
				    });

			}
			
			function search(obj){
				var group = $(obj).val();
				if (group == ""){
					window.location.href = "<webpath:path/>/api/user/list";
				} else {
					window.location.href = "<webpath:path/>/api/user/list?groups=" + group;
				}
				
			}
		</script>
