package com.qiankun.controller.rainbowplan;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiankun.annotation.Auth;
import com.qiankun.config.WxMaConfiguration;
import com.qiankun.config.WxMaProperties;
import com.qiankun.dao.RainbowPlanUserDao;
import com.qiankun.dao.WishDao;
import com.qiankun.entity.RainbowPlanUser;
import com.qiankun.entity.Wish;
import com.qiankun.utils.JwtTokenUtil;
import com.qiankun.vo.PublishWish;
import com.qiankun.vo.RegisterInfo;
import com.qiankun.vo.UserInfo;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

@RestController
@RequestMapping("/wx/rainbowplan")
public class RainbowPlanController {
    private final Logger logger = LoggerFactory.getLogger(RainbowPlanController.class);
    @Autowired
    private JwtTokenUtil tokenUtil;
    @Autowired
    private RainbowPlanUserDao userDao;
    @Autowired
    private WishDao wishDao;
    @Autowired
    private WxMaProperties propertis;
    private ResourceBundle rb = ResourceBundle.getBundle("system");
    private String uploadAvatarPath = File.separator + "rainbowplan" + File.separator + "uploadAvatar";
    private String uploadWishImagePath = File.separator + "rainbowplan" + File.separator + "wishUploadImage";

    private String getAppid(){
        return propertis.getConfigs().get(0).getAppid();
    }


    @Auth(verifyLogin = false,verifyURL = false)
    @RequestMapping(value = "/login",method = RequestMethod.GET)
    public Map<String,Object> login(@RequestParam String code){
        if (StringUtils.isBlank(code)) {
            return null;
        }

        final WxMaService wxService = WxMaConfiguration.getMaService(getAppid());

        try {
            WxMaJscode2SessionResult session = wxService.getUserService().getSessionInfo(code);
            this.logger.info(session.getSessionKey());
            this.logger.info(session.getOpenid());
            Map<String,Object> result = Maps.newConcurrentMap();

            RainbowPlanUser userInfo = userDao.findByOpenid(session.getOpenid());
            if (userInfo != null){
                String sKey = tokenUtil.generateToken(userInfo.getOpenid());
                result.put("sKey",sKey);
                result.put("userInfo",userInfo);
            }else {
                result.put("sKey","");
                result.put("userInfo",null);
            }

            return result;
        } catch (WxErrorException e) {
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }
    @Auth(verifyLogin = false,verifyURL = false)
    @RequestMapping(value = "/register",method = RequestMethod.POST)
    public String register(@RequestBody RegisterInfo info) throws Exception {
        if (Strings.isNullOrEmpty(info.getOpenid())){
            throw new IllegalArgumentException("请求参数错误");
        }
        RainbowPlanUser user = new RainbowPlanUser();
        user.setPhone(info.getPhone());
        user.setName(info.getName());
        user.setGender(info.getGender());
        if (Strings.isNullOrEmpty(info.getInviter())){
            user.setStatus(RainbowPlanUser.STATUS_UNAUDIT);
        }else if (inviterExist(info.getInviter())){
            user.setStatus(RainbowPlanUser.STATUS_AUDIT);
            user.setInviterId(info.getInviter());
        }else {
            throw new Exception("注册失败，邀请者不存在");
        }


        userDao.save(user);
        return tokenUtil.generateToken(info.getOpenid());
    }

    private boolean inviterExist(String inviterId) {
        //TODO 判断邀请人是否存在
        return true;
    }

    @Auth(verifyLogin = false,verifyURL = false)
    @RequestMapping(value = "/userInfo",method = RequestMethod.GET)
    public RainbowPlanUser getUserInfo(@RequestHeader String sKey) throws Exception {
        if (Strings.isNullOrEmpty(sKey)){
            throw new IllegalArgumentException("请求参数错误");
        }
        String openid = tokenUtil.getUsernameFromToken(sKey);
        RainbowPlanUser user = userDao.findByOpenid(openid);
        if (user == null) {
            throw new Exception("请求的用户不存在");
        }

        return user;
    }
    @Auth(verifyLogin = false,verifyURL = false)
    @RequestMapping(value = "/userInfo",method = RequestMethod.POST)
    public String updateUserInfo(@RequestBody UserInfo info,@RequestHeader String sKey) throws Exception {
        if (Strings.isNullOrEmpty(sKey)){
            throw new IllegalArgumentException("请求参数错误");
        }
        String openid = tokenUtil.getUsernameFromToken(sKey);
        RainbowPlanUser user = userDao.findByOpenid(openid);
        if (user != null){
            user.setPhone(info.getPhone());
            user.setName(info.getName());
            user.setGender(info.getGender());
            user.setBirthday(info.getBirthday());
            user.setBedNum(info.getBedNum());
            user.setReceiveName(info.getReceiveName());
            user.setConnectTel(info.getConnectTel());
            user.setReceiveAddress(info.getReceiveAddress());
        }else {
            throw new Exception("保存失败，请求用户不存在");
        }

        return "OK";
    }

    @Auth(verifyLogin = false,verifyURL = false)
    @RequestMapping(value = "/userInfoWithAvatar",method = RequestMethod.POST)
    public String updateUserInfoWithAvatar(UserInfo info, @RequestHeader String sKey) throws Exception {
        if (Strings.isNullOrEmpty(sKey)){
            throw new IllegalArgumentException("请求参数错误");
        }
        String openid = tokenUtil.getUsernameFromToken(sKey);
        RainbowPlanUser user = userDao.findByOpenid(openid);
        if (user != null){
            if (!info.getFile().isEmpty()){
                String originalFileName = info.getFile().getOriginalFilename();
                String rootPath = rb.getString("file_path");
                File destFile = new File(rootPath + uploadAvatarPath,originalFileName);
                FileUtils.writeByteArrayToFile(destFile,info.getFile().getBytes());
                user.setPhone(info.getPhone());
                user.setName(info.getName());
                user.setGender(info.getGender());
                user.setBirthday(info.getBirthday());
                user.setBedNum(info.getBedNum());
                user.setReceiveName(info.getReceiveName());
                user.setConnectTel(info.getConnectTel());
                user.setReceiveAddress(info.getReceiveAddress());
                user.setAvatar(uploadAvatarPath + File.separator + originalFileName);
                userDao.update(user);
            }else {
                throw new Exception("保存失败，请上传图片");
            }
        }else {
            throw new Exception("保存失败，请求用户不存在");
        }
        return "OK";
    }
    @Auth(verifyLogin = false,verifyURL = false)
    @RequestMapping(value = "/publishWish",method = RequestMethod.POST)
    public String publishWish(PublishWish publishWish,@RequestHeader String sKey) throws Exception {
        if (Strings.isNullOrEmpty(sKey)){
            throw new IllegalArgumentException("请求参数错误");
        }
        String openid = tokenUtil.getUsernameFromToken(sKey);
        RainbowPlanUser user = userDao.findByOpenid(openid);
        if (user != null){
            if (!publishWish.getFile().isEmpty()){

                String originalFileName = publishWish.getFile().getOriginalFilename();
                String rootPath = rb.getString("file_path");
                File destFile = new File(rootPath + uploadWishImagePath,originalFileName);
                FileUtils.writeByteArrayToFile(destFile,publishWish.getFile().getBytes());
                Wish wish = new Wish();
                wish.setTitle(publishWish.getTitle());
                wish.setContent(publishWish.getWish());
                wish.setUploadImage(uploadWishImagePath + File.separator + originalFileName);
                wish.setStatus(Wish.STATUS_PUBLISH);
                wish.setRainbowPlanUserId(user.getId());
                wishDao.save(wish);
            }else {
                throw new Exception("保存失败，请上传图片");
            }
        }else {
            throw new Exception("保存失败，请求用户不存在");
        }

        return "OK";
    }
    @Auth(verifyLogin = false,verifyURL = false)
    @RequestMapping(value = "/wish/list",method = RequestMethod.GET)
    public List<Wish> wishList(@RequestHeader String sKey) throws Exception {
        if (Strings.isNullOrEmpty(sKey)){
            throw new IllegalArgumentException("请求参数错误");
        }
        String openid = tokenUtil.getUsernameFromToken(sKey);
        RainbowPlanUser user = userDao.findByOpenid(openid);
        List<Wish> resultList = Lists.newArrayList();
        if (user != null){
            wishDao.findByRainbowPlanUserId(user.getId());
        }else {
            throw new Exception("获取数据失败，请求用户不存在");
        }
        return resultList;
    }
    @Auth(verifyLogin = false,verifyURL = false)
    @RequestMapping(value = "/wish",method = RequestMethod.GET)
    public Wish getWish(@RequestParam String id,@RequestHeader String sKey){
        if (Strings.isNullOrEmpty(sKey)){
            throw new IllegalArgumentException("请求参数错误");
        }
        String openid = tokenUtil.getUsernameFromToken(sKey);

        Wish wish = wishDao.findById(id);

        return wish;

    }


    @Auth(verifyLogin = false,verifyURL = false)
    @RequestMapping(value = "/loadResource",method = RequestMethod.GET)
    public ResponseEntity<byte[]> loadResource(@RequestParam String imageName) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        File file = new File(rb.getString("file_path"),imageName);
        return new ResponseEntity<>(FileUtils.readFileToByteArray(file),headers, HttpStatus.OK);
    }
}
