<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld"%>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld"%>

<head>


</head>
		

<div class="main-content">
	<div class="breadcrumbs" id="breadcrumbs">
		

		<ul class="breadcrumb">
			<li>
				<i class="icon-home home-icon"></i>
				<a href="#">首页</a>
			</li>
			<li class="active">彩虹计划</li>
			<li class="active">用户</li>
			<li class="active">保存</li>
		</ul><!-- .breadcrumb -->

		
	</div>
	<div class="page-content">
		<div class="row">
		
			<div class="col-xs-12">
				
				<form action="#" id="userForm" name="userForm" method="post" onsubmit="return false" class="form-horizontal" role="form">
				<input type="hidden" id="id" name="id" value="${user.id}"/>
				<div class="row">
				<div class="col-xs-12">
				<h3 class="header smaller lighter blue">用户信息</h3></div>
				</div>
				
				
				<div class="row">
				<div class="col-xs-4">
				
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1">  用户类型 </label>

						<div class="col-sm-9">
							<select class="col-xs-10 col-sm-10" id="type" name="type">
									<option value="0" <c:if test="${user.type==0}">selected</c:if>>小朋友</option>
									<option value="1" <c:if test="${user.type==1}">selected</c:if>>爱心人士</option>
							</select>
						  
						</div>
					</div>
										
										
					<div class="form-group children">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1">  状态 </label>

						<div class="col-sm-9">
							<select class="col-xs-10 col-sm-10" id="status" name="status">
									<option value="0" <c:if test="${user.status==0}">selected</c:if>>未审核</option>
									<option value="1" <c:if test="${user.status==1}">selected</c:if>>已审核</option>
							</select>
						  
						</div>
					</div>
				
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> <font color="red">*</font> 姓名 </label>

						<div class="col-sm-9">
							<input type="text" id="name" name="name" value="${user.name}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
					
					<div class="form-group children">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly"> 昵称 </label>

						<div class="col-sm-9">
							<input type="text" id="nickName" name="nickName" value="${user.nickName}" class="col-xs-10 col-sm-10" />
							
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-2"> 性别 </label>

						<div class="col-sm-9">
						
						<label>
							<input name="gender" type="radio" class="ace" value="男" <c:if test="${user.gender=='男'}">checked</c:if>>
							<span class="lbl"> 男</span>
						</label>
						<label>
							<input name="gender" type="radio" class="ace" value="女" <c:if test="${user.gender=='女'}">checked</c:if>>
							<span class="lbl"> 女</span>
						</label>							
													
							
						</div>
					</div>

					

					<div class="form-group children">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly">  出生日期 </label>

						<div class="col-sm-9">
							<input class="col-xs-10 col-sm-10" id="birthday" name="birthday" type="text" autocomplete="off" data-date-format="yyyy-mm-dd" value="${user.birthday}"/>
							
						</div>
					</div>

					
					<div class="form-group children">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly">  楼层床号 </label>

						<div class="col-sm-9">
							<input class="col-xs-10 col-sm-10" id="bedNum" name="bedNum" type="text" autocomplete="off" data-date-format="yyyy-mm-dd" value="${user.bedNum}"/>
							
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly">  收件人姓名 </label>

						<div class="col-sm-9">
							<input class="col-xs-10 col-sm-10" id="receiveName" name="receiveName" type="text" autocomplete="off" data-date-format="yyyy-mm-dd" value="${user.receiveName}"/>
							
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly">  联系方式</label>

						<div class="col-sm-9">
							<input class="col-xs-10 col-sm-10" id="connectTel" name="connectTel" type="text" autocomplete="off" data-date-format="yyyy-mm-dd" value="${user.connectTel}"/>
							
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly">  收件地址</label>

						<div class="col-sm-9">
							<input class="col-xs-10 col-sm-10" id="receiveAddress" name="receiveAddress" type="text" autocomplete="off" data-date-format="yyyy-mm-dd" value="${user.receiveAddress}"/>
							
						</div>
					</div>
				
					
					
					
				</div>
				
				
				<div class="col-xs-4">
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly"> 户籍所在地 </label>

						<div class="col-sm-9">
							<input type="text" id="domicilePlace" name="domicilePlace" value="${user.domicilePlace}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
				
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> <font color="red">*</font> 经常居住地</label>

						<div class="col-sm-9">
							<input type="text" id="addr" name="addr" value="${user.addr}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly"> 学历</label>

						<div class="col-sm-9">
							<select class="col-xs-10 col-sm-10" id="education" name="education">
								<option value="">请选择</option>
								<c:forEach var="value" items="${dict.education}">
									<option value="${value}" <c:if test="${user.education==value}">selected</c:if>>${value}</option>
								</c:forEach>
							</select>
							
						</div>
					</div>
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 工作单位/学校 </label>

						<div class="col-sm-9">
							<input type="text" id="unit" name="unit" value="${user.unit}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 职业 </label>

						<div class="col-sm-9">
							<select class="col-xs-10 col-sm-10" id="profession" name="profession">
								<option value="">请选择</option>
								<c:forEach var="value" items="${dict.profession}">
									<option value="${value}" <c:if test="${user.profession==value}">selected</c:if>>${value}</option>
								</c:forEach>
							</select>
							
						</div>
					</div>
					
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 单位/学校地址 </label>

						<div class="col-sm-9">
							<input type="text" id="unitAddr" name="unitAddr" value="${user.unitAddr}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
					
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 单位/学校电话 </label>

						<div class="col-sm-9">
							<input type="text" id="unitTel" name="unitTel" value="${user.unitTel}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> <font color="red">*</font> 本人手机 </label>

						<div class="col-sm-9">
							<input type="text" id="mobile" name="mobile" value="${user.mobile}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 固定电话 </label>

						<div class="col-sm-9">
							<input type="text" id="tel" name="tel" value="${user.tel}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
				
				
				</div>
				
				
				<div class="col-xs-4">
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 邮箱 </label>

						<div class="col-sm-9">
							<input type="text" id="email" name="email" value="${user.email}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> <font color="red">*</font>QQ号码 </label>

						<div class="col-sm-9">
							<input type="text" id="qq" name="qq" value="${user.qq}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 微信号 </label>

						<div class="col-sm-9">
							<input type="text" id="weixin" name="weixin" value="${user.weixin}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
					
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 无偿献血次数 </label>

						<div class="col-sm-9">
							<input type="text" id="donateBloodCount" name="donateBloodCount" value="${user.donateBloodCount}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 血型 </label>

						<div class="col-sm-9">
							<select class="col-xs-10 col-sm-10" id="bloodType" name="bloodType">
								<option value="">请选择</option>
								<c:forEach var="value" items="${dict.bloodType}">
									<option value="${value}" <c:if test="${user.bloodType==value}">selected</c:if>>${value}</option>
								</c:forEach>
							</select>
						</div>
					</div>
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 身高 </label>
						<div class="col-sm-9">
							<input type="text" id="height" name="height" value="${user.height}" class="col-xs-10 col-sm-10" />
							<span class="help-inline col-xs-12 col-sm-2">
								<span class="middle">cm</span>
							</span>
						</div>
					</div>
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 体重 </label>
						<div class="col-sm-9">
							<input type="text" id="weight" name="weight" value="${user.weight}" class="col-xs-10 col-sm-10" />
							<span class="help-inline col-xs-12 col-sm-2">
								<span class="middle">kg</span>
							</span>
						</div>
					</div>
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 备注 </label>

						<div class="col-sm-9">
							<textarea rows="4" class="col-xs-10 col-sm-10" id="remark" name="remark">${user.remark}</textarea>
						</div>
					</div>
					
				
				</div>
				</div>
				
				
					<div class="col-md-offset-3 col-md-9">
						<button class="btn btn-sm btn-success" type="submit">
							<i class="icon-save bigger-110"></i>
							保存
						</button>

						&nbsp; &nbsp; &nbsp;
						<a class="btn btn-sm btn-success" href="javascript:history.go(-1)">
							<i class="icon-reply bigger-110"></i>
							返回
						</a>
					</div>
				
				
			</form>
			
			
											
											
										
			</div>
			
		</div>
	</div>
	
	
	
	
	
	
</div>
<script src="<webpath:path/>/resources/js/user/cityData.js" type="text/javascript"></script>
<script src="<webpath:path/>/resources/js/user/user.js" type="text/javascript"></script>