package com.qiankun.dao;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.qiankun.dao.core.AbsDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.Wish;
import com.qiankun.pages.IPageList;
import com.qiankun.pages.PageListImpl;

@Repository
public class WishDaoImpl extends AbsDao<Wish,String> implements WishDao {
	
	private static final String FIND = " from Wish";
    private static final String FIND_BY_RAINBOWPLANUSERID_SQL = " from Wish where rainbowPlanUserId = ? and activityId = ? order by createTime desc";
    private static final String FIND_BY_AVAILABLE_ACTIVITY_SQL = " from Wish where activityId = ? order by status asc,createTime desc";
    private static final String FIND_BY_VOLUNTEE_ID = " from Wish where volunteerId = ? order by createTime desc";
    @Override
    public IPageList<Wish> findByRainbowPlanUserId(String userId, String activityId, Hints hints) {
        IPageList<Wish> wishPageList = new PageListImpl<Wish>();
        wishPageList.setRecords(find(FIND_BY_RAINBOWPLANUSERID_SQL,hints,userId,activityId));
        wishPageList.setRecordTotal(findCount(" select count(*) "+ FIND_BY_RAINBOWPLANUSERID_SQL,userId,activityId));
        return wishPageList;
    }

    
    
    @Override
    public IPageList<Wish> findPages(String searchStr, String activityId, String order, String sort, Hints hints) {
    	
    	String hql = "";
    	if (StringUtils.isNotBlank(searchStr)) {
    		if (StringUtils.isBlank(hql)) {
    			hql += " where ";
    		} else {
    			hql += " and ";
    		}
    		String param = "%" + searchStr + "%";
    		
    		hql += " children.phone like '"+param+"' or volunteer.phone like '"+param+"' or children.name like '"+param+"' or volunteer.name like '"+param+"' ";
    	}
    	
    	if (StringUtils.isNotBlank(activityId)) {
    		if (StringUtils.isBlank(hql)) {
    			hql += " where ";
    		} else {
    			hql += " and ";
    		}
    		
    		
    		hql += " activity.id= '"+ activityId +"'";
    		
    	}
    	
        IPageList<Wish> wishPageList = new PageListImpl<Wish>();
        wishPageList.setRecords(find(FIND + hql + sortHQL(order, sort),hints));
        wishPageList.setRecordTotal(findCount(" select count(*) "+ FIND + hql));
        return wishPageList;
    }
    
    @Override
    public IPageList<Wish> findAllByAvailableActivity(String activityId,Hints hints) {
        IPageList<Wish> wishPageList = new PageListImpl<Wish>();
        wishPageList.setRecords(find(FIND_BY_AVAILABLE_ACTIVITY_SQL,hints,activityId));
        wishPageList.setRecordTotal(findCount(" select count(*) "+ FIND_BY_AVAILABLE_ACTIVITY_SQL,activityId));
        return wishPageList;
    }

    @Override
    public IPageList<Wish> findByVolunteeId(String volunteeId, Hints hints) {
        IPageList<Wish> wishPageList = new PageListImpl<Wish>();
        wishPageList.setRecords(find(FIND_BY_VOLUNTEE_ID,hints,volunteeId));
        wishPageList.setRecordTotal(findCount(" select count(*) "+ FIND_BY_VOLUNTEE_ID,volunteeId));
        return wishPageList;
    }

    @Override
    public Wish findById(String id) {
        return findUnique("from Wish where id = ?",new Hints(),id);
    }

    @Transactional
    @Override
    public Wish save(Wish entity) {
        return super.save(entity);
    }

    @Transactional
    @Override
    public void update(Wish entity) {
        super.update(entity);
    }
}
