package com.qiankun.controller.rainbowplan;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import com.qiankun.controller.base.BaseController;
import com.qiankun.dao.RainbowPlanUserDao;
import com.qiankun.dao.WishDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.Activity;
import com.qiankun.entity.RainbowPlanUser;
import com.qiankun.entity.Wish;
import com.qiankun.pages.IPageList;
import com.qiankun.service.ActivityService;
import com.qiankun.vo.RainbowPlanUserVo;
import com.qiankun.vo.WishVo;

@Controller
public class RainbowPlanWebController extends BaseController<Object>{
	
	@Autowired
    private RainbowPlanUserDao userDao;
	
	@Autowired
    private WishDao wishDao;
	
	@Autowired
    private ActivityService activityService;
	
	@RequestMapping("/rainbow/user/list")
	public ModelAndView userlist(RainbowPlanUserVo userVo,HttpServletResponse response, HttpServletRequest request) throws Exception {
		ModelAndView view = new ModelAndView();
		 
		 
        IPageList<RainbowPlanUser> userPage = userDao.findUserPage(userVo.getSearchStr(), userVo.getType(), userVo.getStatus(), userVo.getOrder(), userVo.getSort(), 
					new Hints(getStartRow(request), getPageCount(request)));
			
		view.getModelMap().addAttribute("userPage", userPage);
		view.getModelMap().addAttribute("pageCount", getPageCount(request));
		view.getModelMap().addAttribute("pageNumber", getPageNumber(request));
		view.getModelMap().addAttribute("userVo", userVo);
		view.setViewName("rainbow/userlist");
        
        return view;
		
	 }
	
	
	@RequestMapping("/rainbow/wish/list")
	public ModelAndView wishlist(WishVo wishVo,HttpServletResponse response, HttpServletRequest request) throws Exception {
		ModelAndView view = new ModelAndView();
		
		List<Activity> activitylist = activityService.findByAavailableAndType(null, "3");
		
        IPageList<Wish> wishPage = wishDao.findPages(wishVo.getSearchStr(), wishVo.getActivityId(), wishVo.getOrder(), wishVo.getSort(), new Hints(getStartRow(request), getPageCount(request)));
		
        view.getModelMap().addAttribute("activitylist", activitylist);
		view.getModelMap().addAttribute("wishPage", wishPage);
		view.getModelMap().addAttribute("pageCount", getPageCount(request));
		view.getModelMap().addAttribute("pageNumber", getPageNumber(request));
		view.getModelMap().addAttribute("wishVo", wishVo);
		view.setViewName("rainbow/wishlist");
        
        return view;
		
	 }
	 
}
