package com.qiankun.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.qiankun.dao.ActivityDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.Activity;
import com.qiankun.pages.IPageList;

@Service
public class ActivityService {

	@Autowired
	private ActivityDao activityDao;
	
	public Activity findById(String id) {
		Activity activity = activityDao.find(id);
		return activity;
	}
	
	
	@Transactional
	public void save(Activity activity) {
		activityDao.save(activity);		
	}
	
	@Transactional
	public void remove(String id) {
		activityDao.remove(id);
	}

	public IPageList<Activity> findByActivitys(String searchStr,String type,String order,String sort, Hints hints){
		IPageList<Activity> activitys = activityDao.findActivityPage(searchStr, type, order, sort, hints);
		return activitys;
	}

}
