﻿<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld"%>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld"%>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>后台系统</title>
<link rel="stylesheet" type="text/css" href="<webpath:path/>/resources/assets/css/bootstrap.min.css"/>
<link href="<webpath:path/>/resources/css/login_css.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="<webpath:path/>/resources/js/tools/jquery.min.js"></script>
<script type="text/javascript" src="<webpath:path/>/resources/js/tools/jquery.validate.js"></script>
	<script type="text/javascript" src="<webpath:path/>/resources/assets/js/bootbox.min.js"></script>
	<script type="text/javascript" src="<webpath:path/>/resources/assets/js/bootstrap.min.js"></script>
	<script type="text/javascript" src="<webpath:path/>/resources/js/argus.js"></script>
<script type="text/javascript">
	var webPath="<webpath:path/>";
	$(document).ready(function(){
		$("#submitForm").validate({
			rules:{
				userName:{
					required: true
			      	},
			    pwd:{
					required:true
				    }
				},
			messages:{
				userName:{
					required:"请填写用户名!"
			      	},
			    pwd:{
					required:"请填写密码!"
			      	}
				},
			submitHandler:function(form){
				var userName=$('#userName').val();
				var pwd=$('#pwd').val();
				$.ajax({
					  type: 'POST',
					  url: '/api/signin',
					  dataType:'json',
					  data: {
						  userName:userName,
						  pwd:pwd
					  },
					  success: function(data){
						  var status = data.status;
							if(status == 1){
								window.location.href = webPath + "/default";
							}else if(status == 0){
								bootbox.dialog({
									message:"请核对用户名或密码是否正确！",
									buttons:{
										"success":{
											"label":"OK",
											"className":"btn-sm btn-primary"
											}
										}
									});
							} 
						  }
					});
			}
		});
	});
	
</script>
</head>
<body>
	<div id="login_center">
		<div id="login_area">
			<div id="login_box">
				<div id="login_form">
					<form id="submitForm" action="" method="post">
						<div id="login_tip">
							<span id="login_err" class="sty_txt2"></span>
						</div>
						<div>
							 用户名：<input type="text" name="userName" class="username" id="userName">
						</div>
						<div>
							密&nbsp;&nbsp;&nbsp;&nbsp;码：<input type="password" name="pwd" class="pwd" id="pwd">
						</div>
						<div id="btn_area">
							<input type="submit" class="login_btn" id="login_sub"  value="登  录">
							<input type="reset" class="login_btn" id="login_ret" value="重 置">
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<script type="text/javascript">

		
	</script>
</body>
</html>