<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld"%>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld"%>

<head>


</head>
		

<div class="main-content">
	<div class="breadcrumbs" id="breadcrumbs">
		

		<ul class="breadcrumb">
			<li>
				<i class="icon-home home-icon"></i>
				<a href="#">首页</a>
			</li>
			<li class="active">活动管理</li>
			<li class="active">保存</li>
		</ul><!-- .breadcrumb -->

		
	</div>
	<div class="page-content">
		<div class="row">
		
			<div class="col-xs-12">
				
				<form action="#" id="activityForm" name="activityForm" method="post" onsubmit="return false" class="form-horizontal" role="form">
				<input type="hidden" id="id" name="id" value="${activity.id}"/>
				<div class="row">
				<div class="col-xs-12">
				<h3 class="header smaller lighter blue">活动信息</h3></div>
				</div>
				
				
				<div class="row">
				<div class="col-xs-5">
				
					
						
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1">  活动类型 </label>

						<div class="col-sm-9">
							<select class="col-xs-10 col-sm-10" id="type" name="type">
									<option value="1" <c:if test="${activity.type==1}">selected</c:if>>采血</option>
									<option value="2" <c:if test="${activity.type==2}">selected</c:if>>公益</option>
									<option value="3" <c:if test="${activity.type==3}">selected</c:if>>彩虹</option>
									<option value="4" <c:if test="${activity.type==4}">selected</c:if>>其他</option>
							</select>
						  
						</div>
					</div>
				
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> <font color="red">*</font> 活动名称 </label>

						<div class="col-sm-9">
							<input type="text" id="name" name="name" class="col-xs-10 col-sm-10" value="${activity.name}"/>
						</div>
					</div>

					

					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-2"> 活动地址 </label>

						<div class="col-sm-9">
						
						<input type="text" id="addr" name="addr" class="col-xs-10 col-sm-10" value="${activity.addr}"/>
												
													
							
						</div>
					</div>

					

					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly"> <font color="red">*</font> 活动时间 </label>

						<div class="col-sm-9">
							<input class="col-xs-10 col-sm-10" id="day" name="day" type="text" autocomplete="off" data-date-format="yyyy-mm-dd hh:ss" value="<fmt:formatDate value='${activity.day}' pattern='yyyy-MM-dd HH:mm:ss' />"/>
							
						</div>
					</div>

					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly"> <font color="red">*</font> 最大人数</label>

						<div class="col-sm-9">
							<input class="col-xs-10 col-sm-10" id="max" name="max" type="text"  value="${activity.max}"/>

						</div>
					</div>

					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly"> <font color="red">*</font> 适用人群 </label>

						<div class="col-sm-9">
							<select class="col-xs-10 col-sm-10" id="crowd" name="crowd">
									<option value="0" <c:if test="${activity.crowd == 0}">selected</c:if>>所有人</option>
									<option value="1" <c:if test="${activity.crowd == 1}">selected</c:if>>捐献志愿者</option>
									<option value="2" <c:if test="${activity.crowd == 2}">selected</c:if>>未采血用户</option>
							</select>
							
						</div>
					</div>

					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly"> 活动状态 </label>

						<div class="col-sm-9">
							<select name="available" id="available" class="col-xs-10 col-sm-10">  
							    
								<option value="true" <c:if test="${activity.available==true}">selected</c:if>>正常</option>
								<option value="false" <c:if test="${activity.available==false}">selected</c:if>>关闭</option>
								
							</select>  
							
						</div>
					</div>
					
				
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-input-readonly"> 联系人</label>

						<div class="col-sm-9">
							<input type="text" id="contacts" name="contacts" value="${activity.contacts}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
				
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> <font color="red">*</font> 电话</label>

						<div class="col-sm-9">
							<input type="text" id="tel" name="tel" value="${activity.tel}" class="col-xs-10 col-sm-10" />
						</div>
					</div>
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1"> 详细信息 </label>

						<div class="col-sm-9">
							<textarea rows="4" class="col-xs-10 col-sm-10" id="content" name="content">${activity.content}</textarea>
						</div>
					</div>
					
				
				</div>
				<div class="col-xs-5">
					<div class="form-group">
						<label class="col-sm-3 control-label no-padding-right" for="form-field-1">图片</label>

						<div class="col-sm-9">
							<c:if test="${activity.uploadImage!=null}">
							<img src="<webpath:path/>/wx/rainbowplan/loadResource?imageName=${activity.uploadImage}" width="200"/><br></c:if>
							<input type="file" id="input_file" name="file" >
						</div>
					</div>
						
				</div>
				
				
				</div>
				
				
				
				
					<div class="col-md-offset-3 col-md-9">
						<button class="btn btn-sm btn-success" type="submit">
							<i class="icon-save bigger-110"></i>
							保存
						</button>

						&nbsp; &nbsp; &nbsp;
						<a class="btn btn-sm btn-success" href="javascript:history.go(-1)">
							<i class="icon-reply bigger-110"></i>
							返回
						</a>
					</div>
				
				
			</form>
			
			
											
											
										
			</div>
			
		</div>
	</div>
	
	
	
	
	
	
</div>
<script src="<webpath:path/>/resources/js/activity/activity.js" type="text/javascript"></script>