package com.qiankun.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.qiankun.dao.CertificateDao;
import com.qiankun.entity.Certificate;

@Service
public class CertificateService {

	@Autowired
	private CertificateDao certificateDao;
	
	public Certificate findById(String id) {
		Certificate certificate = certificateDao.find(id);
		return certificate;
	}

	@Transactional
	public void remove(String id) {
		certificateDao.remove(id);
	}
	
	@Transactional
	public Certificate save(Certificate certificate) {
		return certificateDao.save(certificate);		
	}


	public List<Certificate> findByAll() {
        return certificateDao.findAll();
	}
	 

	


}
