package com.qiankun.controller;
 
import java.io.File;
import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import com.qiankun.controller.base.BaseController;
import com.qiankun.entity.Certificate;
import com.qiankun.service.CertificateService;
 
@Controller
public class CertificateController extends BaseController<Object>{
 
	@Autowired
	private CertificateService certificateService;
	
	private ResourceBundle rb = ResourceBundle.getBundle("system");
	private String certificateImagePath = File.separator + rb.getString("certificateImage");
	
    
    @RequestMapping("/certificate/list")
    public ModelAndView list(HttpServletResponse response, HttpServletRequest request) throws Exception {
        ModelAndView view = new ModelAndView();			
		view.getModelMap().addAttribute("list", certificateService.findByAll());
        view.setViewName("certificate/list");
        return view;
    }
    
    @RequestMapping("/certificate/add")
    public ModelAndView add(String id) throws Exception {
        ModelAndView view = new ModelAndView();  
        Certificate certificate = new Certificate();
        if(StringUtils.isNotBlank(id)) {
        	certificate = certificateService.findById(id);      
        }
        view.setViewName("activity/saveactivity");
        view.getModel().put("certificate", certificate);
        return view;
    }
    
    
    @RequestMapping("/api/certificate/save")
	public void save(String id, String name, HttpServletResponse response, HttpServletRequest request) throws Exception {
    	Certificate certificate =  new  Certificate();

    	certificateService.save(certificate);
    }

    @RequestMapping("/api/certificate/del")    
    public ModelAndView delActivityReg(String id,  HttpServletResponse response, HttpServletRequest request) throws Exception {
    	ModelAndView view = new ModelAndView();
    	certificateService.remove(id);       	
    	return view;
    }

}