package com.qiankun.entity;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import com.fasterxml.jackson.annotation.JsonIgnore;

@Entity
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
@Inheritance(strategy = InheritanceType.TABLE_PER_CLASS)
public class User {

	@Id
	@GenericGenerator(name = "systemUUID", strategy = "uuid2")
	@GeneratedValue(generator = "systemUUID")
	private String id;
    
    private String userId;   	  //编号
    private String userName; 	  //单位名称
    private String teamName;      //团队名称
    private String mobile;		  //手机
    private String pwd;           //密码
    private String email;
    private String groups;    	  //组

    private String memberName1;	   //成员姓名
    private String memberGender1;  //成员性别
    private String memberTel1;	   //成员电话
    private String memberEmail1;   //成员邮箱
    private String memberGrade1;   //成员年级专业
    
    private String memberName2;	   //成员姓名
    private String memberGender2;  //成员性别
    private String memberTel2;	   //成员电话
    private String memberEmail2;   //成员邮箱
    private String memberGrade2;   //成员年级专业
    
    private String memberName3;	   //成员姓名
    private String memberGender3;  //成员性别
    private String memberTel3;	   //成员电话
    private String memberEmail3;   //成员邮箱
    private String memberGrade3;   //成员年级专业
    
    private String memberName4;	   //成员姓名
    private String memberGender4;  //成员性别
    private String memberTel4;	   //成员电话
    private String memberEmail4;   //成员邮箱
    private String memberGrade4;   //成员年级专业
  
    private String teacher;		  //指导老师   
    private String teacherTel;
    private String teacherEmail;
    
    private String contacts; 	  //联系人
    private String achievement;   //成绩    
    private Date createTime = new Date();

    @OneToMany(fetch = FetchType.LAZY, cascade = { CascadeType.ALL}, orphanRemoval = true, mappedBy = "user")
	@JsonIgnore
	private Set<Product> product = new HashSet<Product>();
    private Boolean isRemove=false;//是否删除用户,默认false
    
    
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public String getMobile() {
		return mobile;
	}
	public void setMobile(String mobile) {
		this.mobile = mobile;
	}
	public String getPwd() {
		return pwd;
	}
	public void setPwd(String pwd) {
		this.pwd = pwd;
	}
	public String getTeacher() {
		return teacher;
	}
	public void setTeacher(String teacher) {
		this.teacher = teacher;
	}
	public String getContacts() {
		return contacts;
	}
	public void setContacts(String contacts) {
		this.contacts = contacts;
	}
	public String getAchievement() {
		return achievement;
	}
	public void setAchievement(String achievement) {
		this.achievement = achievement;
	}
	public Date getCreateTime() {
		return createTime;
	}
	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
	public String getGroups() {
		return groups;
	}
	public void setGroups(String groups) {
		this.groups = groups;
	}
	public Set<Product> getProduct() {
		return product;
	}
	public void setProduct(Set<Product> product) {
		this.product = product;
	}
	public Boolean getIsRemove() {
		return isRemove;
	}
	public void setIsRemove(Boolean isRemove) {
		this.isRemove = isRemove;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public String getTeamName() {
		return teamName;
	}
	public void setTeamName(String teamName) {
		this.teamName = teamName;
	}
	public String getMemberName1() {
		return memberName1;
	}
	public void setMemberName1(String memberName1) {
		this.memberName1 = memberName1;
	}
	public String getMemberGender1() {
		return memberGender1;
	}
	public void setMemberGender1(String memberGender1) {
		this.memberGender1 = memberGender1;
	}
	public String getMemberTel1() {
		return memberTel1;
	}
	public void setMemberTel1(String memberTel1) {
		this.memberTel1 = memberTel1;
	}
	public String getMemberEmail1() {
		return memberEmail1;
	}
	public void setMemberEmail1(String memberEmail1) {
		this.memberEmail1 = memberEmail1;
	}
	public String getMemberGrade1() {
		return memberGrade1;
	}
	public void setMemberGrade1(String memberGrade1) {
		this.memberGrade1 = memberGrade1;
	}
	public String getMemberName2() {
		return memberName2;
	}
	public void setMemberName2(String memberName2) {
		this.memberName2 = memberName2;
	}
	public String getMemberGender2() {
		return memberGender2;
	}
	public void setMemberGender2(String memberGender2) {
		this.memberGender2 = memberGender2;
	}
	public String getMemberTel2() {
		return memberTel2;
	}
	public void setMemberTel2(String memberTel2) {
		this.memberTel2 = memberTel2;
	}
	public String getMemberEmail2() {
		return memberEmail2;
	}
	public void setMemberEmail2(String memberEmail2) {
		this.memberEmail2 = memberEmail2;
	}
	public String getMemberGrade2() {
		return memberGrade2;
	}
	public void setMemberGrade2(String memberGrade2) {
		this.memberGrade2 = memberGrade2;
	}
	public String getMemberName3() {
		return memberName3;
	}
	public void setMemberName3(String memberName3) {
		this.memberName3 = memberName3;
	}
	public String getMemberGender3() {
		return memberGender3;
	}
	public void setMemberGender3(String memberGender3) {
		this.memberGender3 = memberGender3;
	}
	public String getMemberTel3() {
		return memberTel3;
	}
	public void setMemberTel3(String memberTel3) {
		this.memberTel3 = memberTel3;
	}
	public String getMemberEmail3() {
		return memberEmail3;
	}
	public void setMemberEmail3(String memberEmail3) {
		this.memberEmail3 = memberEmail3;
	}
	public String getMemberGrade3() {
		return memberGrade3;
	}
	public void setMemberGrade3(String memberGrade3) {
		this.memberGrade3 = memberGrade3;
	}
	public String getMemberName4() {
		return memberName4;
	}
	public void setMemberName4(String memberName4) {
		this.memberName4 = memberName4;
	}
	public String getMemberGender4() {
		return memberGender4;
	}
	public void setMemberGender4(String memberGender4) {
		this.memberGender4 = memberGender4;
	}
	public String getMemberTel4() {
		return memberTel4;
	}
	public void setMemberTel4(String memberTel4) {
		this.memberTel4 = memberTel4;
	}
	public String getMemberEmail4() {
		return memberEmail4;
	}
	public void setMemberEmail4(String memberEmail4) {
		this.memberEmail4 = memberEmail4;
	}
	public String getMemberGrade4() {
		return memberGrade4;
	}
	public void setMemberGrade4(String memberGrade4) {
		this.memberGrade4 = memberGrade4;
	}
	public String getTeacherTel() {
		return teacherTel;
	}
	public void setTeacherTel(String teacherTel) {
		this.teacherTel = teacherTel;
	}
	public String getTeacherEmail() {
		return teacherEmail;
	}
	public void setTeacherEmail(String teacherEmail) {
		this.teacherEmail = teacherEmail;
	}
	

    
    
}
