<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld"%>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld"%>


<head>
	<style type="text/css">
     	body{
			background:url(<webpath:path/>/resources/images/timg1.jpg);
			filter:"progid:DXImageTransform.Microsoft.AlphaImageLoader(sizingMethod='scale')";  
			-moz-background-size:100% 100%;  
			background-size:100% 100%;  
			background-attachment: fixed;
		}
		.h22 {
			FONT-SIZE: 30px; font-family:PingFangSC,helvetica neue,hiragino sans gb,arial,microsoft yahei ui,microsoft yahei,simsun,"sans-serif" !important;font-weight: bold; COLOR: #f0f0f0; FONT-WEIGHT: 5px;
		}
		.divTityle{
			border-bottom: 1px solid rgba(255,255,255,0.3);	
		}
		.form-control{
			height:26px;
		}
		label.error{
			color:#ff0000;
		}
		label.block{
			margin-bottom:10px;
		}
		.a-upload {
		    padding: 6px 10px;
		    height: 25px;
		    line-height: 10px;
		    position: relative;
		    cursor: pointer;
		    color: #888;
		    background: #fafafa;
		    border: 1px solid #ddd;
		    border-radius: 4px;
		    overflow: hidden;
		    display: inline-block;
		    *display: inline;
		    *zoom: 1;
		    float: left;
		}
		
		.a-upload  input {
		    position: absolute;
		    font-size: 100px;
		    right: 0;
		    top: 0;
		    opacity: 0;
		    filter: alpha(opacity=0);
		    cursor: pointer;
		    height: 20px;
		    width: 75px;
		}
		
		.a-upload:hover {
		    color: #444;
		    background: #eee;
		    border-color: #ccc;
		    text-decoration: none
		}
		
		.upload-div {
			height:35px;
			line-height: 23px;
			font-size: 14px;
		}
		.download-a {
		
			margin-left:15px;
			float: left;
		}
		
	</style>

</head>
	
	<div class="main-container col-sm-12" style="padding:0px; margin:0px;">
			<div class="main-content col-sm-12"  style="padding:0px; margin:0px;">
				<div class="row" style="width:100%;margin:0;">
					<div class="col-sm-12" style="padding:0px; margin:0px;">
						<div class="login-container divTityle" style="width:100%; height:80px;">
							<div class="left col-sm-12 " style="height:0; padding:20px;padding-left:60px;"  >
                            	<img alt="logo" src="<webpath:path/>/resources/images/logo.png" height="40" style=""/>&nbsp;&nbsp;&nbsp;
                                <img alt="wz" src="<webpath:path/>/resources/images/wz.png"  height="40" style="margin-top:5px; "/>&nbsp;&nbsp;&nbsp;
							</div>
		
							<div class="space-6"></div>
							<div class="position-relative" style="top:100px" >
								<div id="login-box" class="login-box visible widget-box no-border " style="width: 800px; margin-left: auto;margin-right: auto; padding: 0px;" >
									<div class="widget-body" style="margin-bottom:100px;">
										<div class="widget-main" style="padding: 40px;">
										
											<h3 class="blue lighter bigger" style="text-align: left;height:50px;">${user.userName}</h3> 
											<div class="space-6"></div>
											<form action="#" id="product_form" name="product_form" method="post"  enctype='multipart/form-data' onsubmit="return false">
												<fieldset>
													<label class="block clearfix">
														<span class="block col-sm-2 ">
														作品名称：
														</span>
														<span class="block col-sm-10 ">
															<input type="text" class="form-control"  id="name" name="name"  value="${product.name}"/>
														</span>
													</label>
													<label class="block clearfix">
														<span class="block col-sm-2 ">
														作品摘要：
														</span>
														<span class="block col-sm-10 ">
															<textarea rows="5" class="form-control" id="content1" name="content1">${product.content1}</textarea>
														</span>
													</label>	
													<label class="block clearfix">
														<span class="block col-sm-2 ">
														作品思路和应用的理论方法：
														</span>
														<span class="block col-sm-10 ">
															<textarea rows="5" class="form-control" id="content2" name="content2">${product.content2}</textarea>
														</span>
													</label>
														
													
													<label class="block clearfix">
														<span class="block col-sm-2 ">
														作品的创新性：
														</span>
														
														<span class="block col-sm-10 ">
															<textarea rows="5" class="form-control" id="content3" name="content3">${product.content3}</textarea>
															
														</span>
													</label>
														
													<div class="block clearfix upload-div">
														<span class="block col-sm-2 ">
														上传报名表：
														</span>
														
														<span class="block col-sm-10 ">
															<a href="javascript:;" class="a-upload" id="enrollUpload">
															<c:if test="${product.enroll==null || product.enroll==''}">
															本地上传
															</c:if>
															<c:if test="${product.enroll!=null && product.enroll!=''}">
															重新上传
															</c:if>
															<input type="file" id="enroll" name="enroll" accept="*" >
															</a>
															
															<a href="<webpath:path/>/api/product/download?type=enroll&fileName=${product.enroll}" target="_blank" id="enrollName" class="download-a"><c:if test="${product.enroll!=null && product.enroll!=''}">${product.enroll}</c:if></a>
															
														</span>
													</div>	
													<div class="block clearfix upload-div">
														<span class="block col-sm-2 ">
														上传报告：
														</span>
														
														<span class="block col-sm-10 ">
															
															<a href="javascript:;" class="a-upload" id="reportUpload">
															<c:if test="${product.report==null || product.report==''}">
															本地上传
															</c:if>
															<c:if test="${product.report!=null && product.report!=''}">
															重新上传
															</c:if>
															<input type="file" id="report" name="report" accept="*" >
															</a>
															
															<a href="<webpath:path/>/api/product/download?type=report&fileName=${product.report}" target="_blank" id="reportName" class="download-a"><c:if test="${product.report!=null && product.report!=''}">${product.report}</c:if></a>
															
														</span>
													</div>	
													<div class="block clearfix upload-div">
														<span class="block col-sm-2 ">
														上传PPT：
														</span>
														
														<span class="block col-sm-10 ">
															<a href="javascript:;" class="a-upload" id="pptUpload">

															<c:if test="${product.ppt==null || product.ppt==''}">
															本地上传
															</c:if>
															<c:if test="${product.ppt!=null && product.ppt!=''}">
															重新上传
															</c:if>
															
															<input type="file" id="ppt" name="ppt" accept="*" >
															</a>
															
															<a href="<webpath:path/>/api/product/download?type=ppt&fileName=${product.ppt}" target="_blank" id="pptName" class="download-a"><c:if test="${product.ppt!=null && product.ppt!=''}">${product.ppt}</c:if></a>
															
														</span>
													</div>	
													<div class="block clearfix upload-div">
														<span class="block col-sm-2 ">
														上传附件：
														</span>
														
														<span class="block col-sm-10 ">
															<a href="javascript:;" class="a-upload" id="attachmentUpload">
															<c:if test="${product.attachment==null || product.attachment==''}">
															本地上传
															</c:if>
															<c:if test="${product.attachment!=null && product.attachment!=''}">
															重新上传
															</c:if>
															
															<input type="file" id="attachment" name="attachment" accept="*" >
															</a>
															
															<a href="<webpath:path/>/api/product/download?type=attachment&fileName=${product.attachment}" target="_blank" id="attachmentName" class="download-a"><c:if test="${product.attachment!=null && product.attachment!=''}">${product.attachment}</c:if></a>
															
														</span>
													</div>
														
													<div class="block clearfix upload-div">
														<span class="block col-sm-12 " style="color:#428bca">
														说明：报名表和报告请上传word文件，附件请上传.zip或.rar的压缩文件
														</span>
													</div>
														<div class="space"></div>
														<div class="clearfix" style="text-align: center;">
															
															<button type="submit" class=" btn btn-sm btn-primary"  style="width:200px;height: 40px;margin-left: auto;margin-right:auto;">
																保存作品
															</button>
															&nbsp;&nbsp;&nbsp;&nbsp;<a href="<webpath:path/>/profile">返回</a>
															
															
														</div>
													
													<div class="space-4"></div>
												</fieldset>
											</form>
										</div><!-- /widget-main -->
									</div><!-- /widget-body -->
								</div><!-- /login-box -->
							</div><!-- /position-relative -->
						</div>
					</div><!-- /.col -->		
				</div><!-- /.row -->
			</div>
		</div>	
	
	


	<script type="text/javascript">
			if("ontouchend" in document)
				document.write("<script src='resources/assets/js/jquery.mobile.custom.min.js'>"+"<"+"/script>");
		</script>
		<script type="text/javascript" src="resources/js/tools/jquerysession.js"></script>
	
		<script type="text/javascript">
			$().ready(function() {
				
				$("#product_form").validate({
					rules:{
						name:{
							required: true
					    },
					    content1:{
							required: true
					    },
					    content2:{
							required: true
						},
						content3:{
							required: true
						}
					},
					messages:{
						name:{
							required:"请填写作品名称!"
					    },
					    content1:{
							required:"请填写作品摘要!"
					    },
					    content2:{
							required:"请填写作品思路和应用的理论方法!"
						},
						content3:{
							required:"请填写作品的创新性!"
						}
					},
					submitHandler:function(form){
						var name=$('#name').val();
						var content1=$('#content1').val();
						var content2=$('#content2').val();
						var content3=$('#content3').val();
						
						$.ajax({
							  type: 'POST',
							  url: '/api/product/save',
							  dataType:'json',
							  data: {
								  name:name,
								  content1:content1,
								  content2:content2,
								  content3:content3
							  },
							  success: function(data){
								  var message = data.message;
								  if (message == "success"){
									  bootbox.dialog({
											message:"作品提交成功！",
											buttons:{
												"success":{
													"label":"OK",
													"className":"btn-sm btn-primary"
													}
												}
											});
								  }
								  
							   }
						  });
					}
				});
			});
			

			var uploading = false;

			$("#enroll").on("change", function(){
				Loading.start("正在上传");
			    if(uploading){
			        alert("文件正在上传中，请稍候");
			        return false;
			    }
			    fileupload("enroll");
			});
			
			$("#report").on("change", function(){
				Loading.start("正在上传");
			    if(uploading){
			        alert("文件正在上传中，请稍候");
			        return false;
			    }
			    fileupload("report");
			});
			
			$("#ppt").on("change", function(){
				Loading.start("正在上传");
			    if(uploading){
			        alert("文件正在上传中，请稍候");
			        return false;
			    }
			    fileupload("ppt");
			});
			
			$("#attachment").on("change", function(){
				Loading.start("正在上传");
			    if(uploading){
			        alert("文件正在上传中，请稍候");
			        return false;
			    }
			    fileupload("attachment");
			});
			
			function fileupload(type){
				var str = ""
				if (type=="enroll"){
					str = "报名表";
				}
				if (type=="report"){
					str = "报告";
				}
				if (type=="ppt"){
					str = "PPT";
				}
				if (type=="attachment"){
					str = "附件";
				}
				
				$.ajax({
			        url: webPath + "/api/product/"+type+"/upload",
			        type: 'POST',
			        cache: false,
			        data: new FormData($('#product_form')[0]),
			        processData: false,
			        contentType: false,
			        dataType:"json",
			        beforeSend: function(){
			            uploading = true;
			        },
			        success : function(data) {
			        	var status = data.status;
			        	if (status==0){
			        			var size = data.size;
			        			if (size!=0){
			        				bootbox.dialog({
										message:"上传失败！文件过大，" + str + "不能超过" + size +"M",
										buttons:{
											"success":{
												"label":"OK",
												"className":"btn-sm btn-primary"
												}
											}
										});
			        			}
			        			
			        	} else if (status == 1){
			        		bootbox.dialog({
								message:"上传成功！",
								buttons:{
									"success":{
										"label":"OK",
										"className":"btn-sm btn-primary"
										}
									}
								});
			        		$("#" + type + "Name").text(data.fileName);
			        		$("#" + type + "Name").attr("href","<webpath:path/>/api/product/download?type=" + type + "&fileName=" + data.fileName)
			        		$("#" + type + "Upload").text("重新上传");
			        		
			        	}
			            uploading = false;
			            Loading.stop();
			        }
			    });
			}
			
			
			
		</script>
