<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld" %>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld" %>

<head>
	

</head>
		

<div class="main-content">
	<div class="breadcrumbs" id="breadcrumbs">
		

		<ul class="breadcrumb">
			<li>
				<i class="icon-home home-icon"></i>
				<a href="#">首页</a>
			</li>
			<li class="active">彩虹计划</li>
			<c:if test="${userVo.type==0}"><li class="active">小朋友</li></c:if>
			<c:if test="${userVo.type==1}"><li class="active">爱心人士</li></c:if>
		</ul><!-- .breadcrumb -->

		
	</div>
	<div class="page-content">
		<div class="row">
			<div class="col-xs-12">
				<div class="pull-right">
					<input type="text" placeholder="查询" class="nav-search-input" id="searchStr" value="${userVo.searchStr}" autocomplete="off">
					<c:if test="${userVo.type==0}"><a href="javascript:void(0);" onclick="user.children();"><i class="icon-search nav-search-icon"></i></a></c:if>
					<c:if test="${userVo.type==1}"><a href="javascript:void(0);" onclick="user.caringPeople();"><i class="icon-search nav-search-icon"></i></a></c:if>	
				</div>
			
										
				<div class="pull-left">共${userPage.recordTotal}条</div>
					<c:if test="${userVo.type==0}">
						<table id="table-data" class="table table-bordered ">
							<thead>
								<tr  class="">
									<th width="5%">用户状态</th>
									<th width="5%">照片</th>
									<th width="6%">注册手机</th>
									<th width="6%">姓名</th>
									<th width="5%">昵称</th>
									<th width="5%">性别</th>
									<th width="6%">出生日期</th>
									<th width="8%">楼层床号</th>
									<th width="7%">疾病</th>
									<th width="6%">收件人</th>
									<th width="6%">联系方式</th>
									<th width="20%">收件地址</th>
									<th width="8%">注册时间</th>
									<th width="7%">操作</th>
								</tr>
							</thead>
				
							<tbody>
								<c:forEach var="user" items="${userPage.records}">
									<tr class="tr-highlight">
									<td title="">
									<c:if test="${user.status==0}"><span class="label label-sm label-warning">未审核</span></c:if>
									<c:if test="${user.status==1}"><span class="label label-sm label-success">已审核</span></c:if></td>
									<td title=""><c:if test="${user.avatar!=null&&user.avatar!=''}"><img alt="" src="<webpath:path/>/wx/rainbowplan/loadResource?imageName=${user.avatar}" width="60" height="60"/></c:if></td>
									<td title="">${user.phone}</td>
									<td title="">${user.name}</td>
									<td title="">
										${user.nickName}
									</td>
									<td title=""><c:if test="${user.gender=='1'}">男</c:if><c:if test="${user.gender=='2'}">女</c:if></td>
									<td title="">${user.birthday}</td>
									<td title="">${user.bedNum}</td>
									<td title="">${user.disease}</td>
									<td title="">${user.receiveName}</td>
									<td title="">${user.connectTel}</td>
									<td title="">${user.receiveAddress}</td>
									<td title=""><fmt:formatDate value='${user.createTime}' pattern='yyyy-MM-dd HH:mm' /></td>
									<td>
										<div class="visible-md visible-lg hidden-sm hidden-xs btn-group">
		
											
				
											<button class="btn btn-xs btn-success" title="添加愿望" onclick="user.openlayer('${user.id}','${user.name}')">
												<i class="icon-lightbulb"></i>
											</button>&nbsp; 
											<button class="btn btn-xs btn-info" title="修改" onclick="window.location.href='<webpath:path/>/rainbow/user/view?id=${user.id}'">
												<i class="icon-edit"></i>
											</button>
											&nbsp; 
											<button class="btn btn-xs btn-danger" title="删除" onclick="user.del('${user.id}')">
												<i class="icon-trash"></i>
											</button>
										</div>
				
										
									</td>
									</tr>
								</c:forEach>
							</tbody>
						</table>
					
					
					</c:if>
					
					
					<c:if test="${userVo.type==1}">
						<table id="table-data" class="table table-bordered ">
							<thead>
								<tr class="">
									<th width="5%">照片</th>
									<th width="6%">注册手机</th>
									<th width="6%">姓名</th>
									<th width="6%">收件人</th>
									<th width="6%">联系方式</th>
									<th width="20%">收件地址</th>
									<th width="10%">注册时间</th>
									<th width="5%">操作</th>
								</tr>
							</thead>
				
							<tbody>
								<c:forEach var="user" items="${userPage.records}">
									<tr class="tr-highlight">									
									<td title=""><c:if test="${user.avatar!=null&&user.avatar!=''}"><img alt="" src="<webpath:path/>/wx/rainbowplan/loadResource?imageName=${user.avatar}" width="60" height="60"/></c:if></td>
									<td title="">${user.phone}</td>
									<td title="">${user.name}</td>
									<td title="">${user.receiveName}</td>
									<td title="">${user.connectTel}</td>
									<td title="">${user.receiveAddress}</td>
									<td title=""><fmt:formatDate value='${user.createTime}' pattern='yyyy-MM-dd HH:mm' /></td>
									<td>
										<div class="visible-md visible-lg hidden-sm hidden-xs btn-group">
		
											<button class="btn btn-xs btn-info" title="修改" onclick="window.location.href='<webpath:path/>/rainbow/user/view?id=${user.id}'">
												<i class="icon-edit"></i>
											</button>
				
											&nbsp; 
											<button class="btn btn-xs btn-danger" title="删除" onclick="user.del('${user.id}')">
												<i class="icon-trash"></i>
											</button>
				
											
										</div>
				
										
									</td>
									</tr>
								</c:forEach>
							</tbody>
						</table>
					
					
					</c:if>
												
					<webpage:page totalCount="${userPage.recordTotal}"
					pageCount="${pageCount}" currentPage="${pageNumber}"
					action="/rainbow/user/list"
					className="pageable-div pagination" 
					innerStyle=" float: left; width: 100%" /> 								

				</div>
			
		</div>
	</div>

</div>


<script>
	  var activityHTML = '<div id="message" style="text-align: center;"></div><div style="display: block;margin-left:auto;margin-right:auto;margin-top:20px;text-align: center;">'
	  +'<select class="" id="activityId" name="activityId"><option value="">请选择活动</option>'
				  
	  <c:forEach var="list" items="${activitylist}">
	  	 activityHTML += '<option value="${list.id}">${list.name}</option>'
	  </c:forEach>
	  	activityHTML += '</select><button class="btn-xs" onclick="user.validateWish()">确定</button></div>';

</script>
<script src="<webpath:path/>/resources/js/rainbow/rainbowuser.js?v=window.number" type="text/javascript"></script>