package com.qiankun.controller.rainbowplan;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import com.qiankun.controller.base.BaseController;
import com.qiankun.dao.RainbowPlanUserDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.RainbowPlanUser;
import com.qiankun.pages.IPageList;
import com.qiankun.vo.RainbowPlanUserVo;

@Controller
public class RainbowPlanUserController extends BaseController<Object>{
	
	@Autowired
    private RainbowPlanUserDao userDao;
	
	@RequestMapping("/rainbow/user/list")
	public ModelAndView list(RainbowPlanUserVo userVo,HttpServletResponse response, HttpServletRequest request) throws Exception {
		ModelAndView view = new ModelAndView();
		 
		 
        IPageList<RainbowPlanUser> userPage = userDao.findUserPage(userVo.getSearchStr(), userVo.getType(), userVo.getStatus(), userVo.getOrder(), userVo.getSort(), 
					new Hints(getStartRow(request), getPageCount(request)));
			
		view.getModelMap().addAttribute("userPage", userPage);
		view.getModelMap().addAttribute("pageCount", getPageCount(request));
		view.getModelMap().addAttribute("pageNumber", getPageNumber(request));
		view.getModelMap().addAttribute("userVo", userVo);
		view.setViewName("rainbow/userlist");
        
        return view;
		
	 }
	 @RequestMapping("/rainbow/user/add")
	 public ModelAndView add(String id, HttpServletRequest request) throws Exception {
		 ModelAndView view = new ModelAndView();
		 
		 RainbowPlanUser rainbowPlanUser=new RainbowPlanUser();
		 rainbowPlanUser.setId("1");
		 rainbowPlanUser.setName("姓名");
		 rainbowPlanUser.setNickName("昵称");
		 rainbowPlanUser.setGender("性别"); 
		 rainbowPlanUser.setBirthday("2017-10-01");
		 rainbowPlanUser.setBedNum("床位");
		 rainbowPlanUser.setStatus(1);
		 rainbowPlanUser.setAvatar("tp");
		 rainbowPlanUser.setInviterId("邀请者");
		
		 view.getModelMap().addAttribute("rainbowPlanUser", rainbowPlanUser);
		 view.getModelMap().addAttribute("pageCount", getPageCount(request));
		 view.getModelMap().addAttribute("pageNumber", getPageNumber(request));
		 view.getModelMap().addAttribute("rainbowPlanId", id);
		 view.setViewName("rainbow/saveuser");
		 return view;
	 }
}
