package com.qiankun.entity;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.util.Date;

@Entity
public class Wish {
    public static final int STATUS_PUBLISH = 0;
    public static final int STATUS_RECEIVE = 1;
    public static final int STATUS_COMPLETE = 2;
    @Id
    @GenericGenerator(name = "systemUUID", strategy = "uuid2")
    @GeneratedValue(generator = "systemUUID")
    private String id; //愿望ID
    private String title;//愿望标题
    private String content;//愿望内容
    private String uploadImage; //上传的图片
    private int status;//愿望状态,0:发布;1:领取;2.寄送中;3:实现
    private String volunteerId; //领取愿望的志愿者ID
    private String rainbowPlanUserId; //小朋友ID
    private Date createTime = new Date();

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getRainbowPlanUserId() {
        return rainbowPlanUserId;
    }

    public void setRainbowPlanUserId(String rainbowPlanUserId) {
        this.rainbowPlanUserId = rainbowPlanUserId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getUploadImage() {
        return uploadImage;
    }

    public void setUploadImage(String uploadImage) {
        this.uploadImage = uploadImage;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getVolunteerId() {
        return volunteerId;
    }

    public void setVolunteerId(String volunteerId) {
        this.volunteerId = volunteerId;
    }
}
