package com.qiankun.dao;

import org.springframework.stereotype.Repository;

import com.qiankun.dao.core.AbsDao;
import com.qiankun.dao.core.Hints;
import com.qiankun.entity.User;
import com.qiankun.pages.IPageList;
import com.qiankun.pages.PageListImpl;

@Repository
public class UserDaoImpl extends AbsDao<User, String> implements UserDao {
	
	private static final String FIND = "from User where ";
	
	private static final String FIND_USER_PAGE = " from User where (mobile like ? or paperId like ? or name like ? or userName like ?) ";
	
//	private static final String FIND_LASTUSER_BY_GROUP = " from User where groups = ? order by createTime desc";
	
	private static final String LOGIN = " from User where mobile = ? and pwd = ? and isRemove=false";
	
	private static final String VALIDATE_PAPERID = " from User where paperId = ?";
	
	private static final String VALIDATE_USERNAME = " from User where userName = ?";
	
	private static final String VALIDATE_PWD = " from User where id = ? and pwd = ? and isRemove=false";
	private static final String FIND_BY_OPENID = "from User where openid = ?";
	private static final String FIND_BY_PAPERID = "from User where paperId = ? and paperType = ?";
	
	@Override
	public Boolean validateUserExistByPaperId(String paperId) {
		Long count = findCount(" select count(*) " + VALIDATE_PAPERID, paperId);
		if (count > 0)
			return true;
		else
			return false;
	}
	
	@Override
	public Boolean validateUserExistByUserName(String userName) {
		Long count = findCount(" select count(*) " + VALIDATE_USERNAME, userName);
		if (count > 0)
			return true;
		else
			return false;
	}
	
//	@Override
//	public User findLastUserByGroup(String groupId) {
//		
//		List<User> records = find(FIND_LASTUSER_BY_GROUP , new Hints(0,1),  groupId);
//		if (records.size()>0) {
//			return records.get(0);
//		} else {
//			return null;
//		}
//		
//		
//	}
	
	
	@Override
	public IPageList<User> findUserPage(String searchStr, String role, String status,String order, String sort, Hints hints) {
		
		if (order == null){
			order = " createTime ";
		}
		if (sort == null){
			sort=" desc ";
		}
		
		String hql = "";
		if (role != null){
			hql = " and role = '" +role+ "' ";
		}
		
		if (status != null){
			hql = " and status = '" +status+ "' ";
		}
		
		if (searchStr == null) {
			searchStr = "%";
		}
		String param = "%" + searchStr + "%";
		IPageList<User> users = new PageListImpl<User>();
		users.setRecords(find(FIND_USER_PAGE + hql + sortHQL(order, sort), hints, param, param, param, param));
		users.setRecordTotal(findCount(" select count(*) " + FIND_USER_PAGE + hql, param, param, param, param));
		
		
		return users;
	}	
	
	
	@Override
	public User login(String mobile, String password) {
		return findUnique(LOGIN, new Hints(), mobile, password);
	}
	
	@Override
	public Boolean validatePwd(String id, String password) {
		Long count = findCount(" select count(*) " + VALIDATE_PWD, id, password);
		if (count > 0)
			return true;
		else
			return false;
		
	}

    @Override
    public User findByOpenid(String openid) {
        return findUnique(FIND_BY_OPENID,new Hints(),openid);
    }

    @Override
    public User findByPaperId(String paperId, String paperType) {
        return findUnique(FIND_BY_PAPERID,new Hints(),paperId,paperType);
    }
}
