package com.qiankun.controller;
 
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.qiankun.annotation.Auth;
import com.qiankun.controller.base.BaseController;
import com.qiankun.entity.Activity;
import com.qiankun.service.ActivityService;
import com.qiankun.vo.ActivityVo;
 
@Controller
public class ActivityController extends BaseController<Object>{
 
	@Autowired
	private ActivityService activityService;
    
    @RequestMapping("/activity/list")
    public ModelAndView list() throws Exception {
        ModelAndView view = new ModelAndView();
        view.setViewName("activity/activitylist");
        return view;
    }
    
    @RequestMapping("/activity/add")
    public ModelAndView userAdd(String id) throws Exception {
        ModelAndView view = new ModelAndView();
        ActivityVo vo = new ActivityVo();
        if(StringUtils.isNotBlank(id)) {
        	Activity activity = activityService.findById(id);
        	
        	
        }
        
        
        view.setViewName("activity/saveactivity");
        view.getModel().put("dict", dict());
        view.getModel().put("activity", vo);
        return view;
    }
    
    @Auth(verifyLogin = false,verifyURL = false)
    @RequestMapping(value = "/wx/api/activity/save",method = RequestMethod.POST)
    public @ResponseBody Map<String,Object> saveUserFormWX(@RequestBody ActivityVo activityVo, HttpServletResponse response, HttpServletRequest request) throws Exception{
    	return this.save(activityVo, response, request);
    }
    
    
    @RequestMapping("/api/activity/save")
	public Map<String, Object> save(ActivityVo activityVo, HttpServletResponse response, HttpServletRequest request) throws Exception {
	    	
	        Map<String, Object> map = new HashMap<>();
	        Activity activity = new Activity();
	    	if (StringUtils.isEmpty(activityVo.getId())) {
	    		Date date = new Date();	
	    		activity.setCreateTime(date);
	    		map.put("status", 1);
	    	} else {
	    		activity = activityService.findById(activityVo.getId());
	    		map.put("status", 2);
	    	}
	    	
	    	activity.setAddr(activityVo.getAddr());
	    	activity.setAvailable(activityVo.getAvailable());
	    	activity.setContacts(activityVo.getContacts());
	    	activity.setContent(activityVo.getContent());
	    	activity.setCrowd(activityVo.getCrowd());
	    	
	    	SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
	    	activity.setDay(sdf.parse(activityVo.getDay()));
	    	activity.setMax(activityVo.getMax());
	    	activity.setName(activityVo.getName());
	    	activity.setTel(activityVo.getTel());
	    	activity.setType(activityVo.getType());
	    	
	    	Activity a = activityService.save(activity);
	    	
	    	map.put("activity", a);
	    	return map;
	    	
	}
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

}