<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld" %>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld" %>

<head>
	

</head>
		

<div class="main-content">
	<div class="breadcrumbs" id="breadcrumbs">
		

		<ul class="breadcrumb">
			<li>
				<i class="icon-home home-icon"></i>
				<a href="#">首页</a>
			</li>
			<li class="active">彩虹计划</li>
			<li class="active">愿望管理</li>
			
		</ul><!-- .breadcrumb -->

		
	</div>
	<div class="page-content">
		<div class="row">
			<div class="col-xs-12">
				<div class="pull-right">
					<select class="" id="activityId" name="nativePlace">
						<option value="">请选择</option>
						<c:forEach var="list" items="${activitylist}">
							<option value="${list.id}" <c:if test="${wishVo.activityId==list.id}">selected</c:if>>${list.name}</option>
						</c:forEach>
					</select>
					<input type="text" placeholder="查询" class="nav-search-input" id="searchStr" value="${wishVo.searchStr}" autocomplete="off">
					<a href="javascript:void(0);" onclick="wish.search();"><i class="icon-search nav-search-icon"></i></a>
				</div>
			
										
				<div class="pull-left">共${wishPage.recordTotal}条</div>
						<table id="table-data" class="table table-bordered ">
							<thead>
								<tr class="" >
									<th class="center" width="2%">
										<label>
											<input type="checkbox" class="ace">
											<span class="lbl"></span>
										</label>
									</th>
									<th width="5%">图片</th>
									<th width="">小朋友</th>
									<th width="">愿望</th>
									<th width="">内容</th>
									<th width="">爱心人士</th>
									<th width="">寄送方式</th>
									<th width="">快递公司</th>
									<th width="">快递单号</th>
									<th width="">所属活动</th>
									<th width="">状态</th>
									<th width="">发布时间</th>
									<th width="5%">操作</th>
								</tr>
							</thead>
				
							<tbody>
								<c:forEach var="wish" items="${wishPage.records}">
									<tr class="tr-highlight">
										<td class="center" width=10>
											<label>
												<input type="checkbox" class="ace" value="${wish.id}">
												<span class="lbl"></span>
											</label>
										</td>
										<td title="" valign="middle"></td>
										<td title="">${wish.children.name}<br/>
										手机：${wish.children.phone}
										</td>
										<td title="" valign="middle">${wish.title}</td>
										<td title="" valign="middle">${wish.content}</td>
										<td title="" valign="middle">${wish.volunteer.name}<br/>
										手机：${wish.volunteer.phone}</td>
										<td title="" valign="middle"><c:if test="${wish.helpType == 1}">自送</c:if><c:if test="${wish.helpType == 1}">快递</c:if></td>
										<td title="" valign="middle">${wish.expressCompany}</td>
										<td title="" valign="middle">${wish.expressCode}</td>
										<td title="" valign="middle">${wish.activity.name}</td>
										<td title="" valign="middle">
										<c:if test="${wish.status == 0}"><span class="label label-warning">发布</span></c:if>
										<c:if test="${wish.status == 1}"><span class="label label-info">领取</span></c:if>
										<c:if test="${wish.status == 2}"><span class="label label-purple">寄送中</span></c:if>
										<c:if test="${wish.status == 3}"><span class="label label-pink">红会代收</span></c:if>
										<c:if test="${wish.status == 4}"><span class="label label-success">完成</span></c:if>
										</td>
										
	
										<td title="" valign="middle"><fmt:formatDate value='${wish.createTime}' pattern='yyyy-MM-dd HH:mm' /></td>
										<td>
											<div class="visible-md visible-lg hidden-sm hidden-xs btn-group">
			
												<%-- <button class="btn btn-xs btn-info" onclick="window.location.href='<webpath:path/>/rainbow/user/add?id=${user.id}'">
													<i class="icon-credit-card bigger-120"></i>
												</button>
												&nbsp; --%>
					
												<!-- <button class="btn btn-xs btn-danger">
													<i class="icon-trash bigger-120"></i>
												</button> -->
					
												
											</div>
					
											
										</td>
									</tr>
								</c:forEach>
							</tbody>
						</table>
					
					
												
					<webpage:page totalCount="${wishPage.recordTotal}"
					pageCount="${pageCount}" currentPage="${pageNumber}"
					action="/rainbow/wish/list"
					className="pageable-div pagination" 
					innerStyle=" float: left; width: 100%" /> 								

				</div>
			
		</div>
	</div>

</div>


<script src="<webpath:path/>/resources/js/rainbow/wish.js" type="text/javascript"></script>