<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ taglib prefix="webpath" uri="/WEB-INF/tlds/path.tld"%>
<%@ taglib prefix="webpage" uri="/WEB-INF/tlds/pageview.tld"%>

<head>
	

</head>
		

<div class="main-content">
	<div class="breadcrumbs" id="breadcrumbs">
		

		<ul class="breadcrumb">
			<li>
				<i class="icon-home home-icon"></i>
				<a href="#">首页</a>
			</li>
			<li class="active">积分管理</li>
			<li class="active">类别</li>
		</ul><!-- .breadcrumb -->

		
	</div>
	<div class="page-content">
		<div class="row">
		
			<div class="col-xs-12">
			<div class="widget-toolbox">
				<div class="btn-group">
					<button class="btn btn-sm btn-success" onclick="window.location.href='<webpath:path/>/points/type/add'">
						<i class="icon-plus-sign-alt bigger-110"></i>
						新增
					</button>
					
					
				</div>
			</div>
			
			<div class="pull-left"></div>
				<table id="table-data" class="table table-bordered ">
					<thead>
						<tr class="">
							<th>名称</th>
							<th>积分</th>
							<th>是否可用</th>
							<th width="100">操作</th>
						</tr>
					</thead>
		
					<tbody>
					
						<c:forEach var="type" items="${typelist}">
						<tr class="tr-highlight">
							
		
							<td title="">${type.name}</td>
							<td title="">${type.point}</td>
							
							<td title=""> <c:if test="${type.available}"><font color=green>正常</font></c:if><c:if test="${!type.available}"><font color=red>关闭</font></c:if></td>
							
							<td>
								<div class="visible-md visible-lg hidden-sm hidden-xs btn-group">
									
		
									<button class="btn btn-xs btn-info" onclick="window.location.href='<webpath:path/>/points/type/add?id=${type.id}'">
										<i class="icon-edit bigger-120"></i>
									</button>
									&nbsp;
		
									<button class="btn btn-xs btn-danger" onclick="points.remove('${type.id}')">
										<i class="icon-trash bigger-120"></i>
									</button>
		
									
								</div>
		
								
							</td>
						</tr>
						
						</c:forEach>
		
						
					</tbody>
				</table>
											
			</div>
			
		</div>
	</div>
	

</div>

<script src="<webpath:path/>/resources/js/points/points.js" type="text/javascript"></script>